/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import com.mojang.datafixers.util.Either;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.base.CEffectAbstractList;
import hellfirepvp.astralsorcery.common.constellation.effect.base.ListEntries;
import hellfirepvp.astralsorcery.common.event.PlayerAffectionFlags;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BubbleColumnBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public class CEffectOctans
extends CEffectAbstractList<ListEntries.CounterMaxEntry> {
    public static PlayerAffectionFlags.AffectionFlag FLAG = CEffectOctans.makeAffectionFlag("octans");
    public static OctansConfig CONFIG = new OctansConfig();
    private static boolean corruptedSkipWaterCheck = false;

    public CEffectOctans(@Nonnull ILocatable origin) {
        super(origin, ConstellationsAS.octans, (Integer)CEffectOctans.CONFIG.maxAmount.get(), (world, pos, state) -> {
            if (!corruptedSkipWaterCheck) {
                pos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos).func_177977_b();
            }
            return corruptedSkipWaterCheck || world.func_175623_d(pos.func_177984_a()) && state.func_177230_c() instanceof FlowingFluidBlock && state.func_185904_a() == Material.field_151586_h && (Integer)state.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0 || state.func_177230_c() instanceof BubbleColumnBlock;
        });
        this.excludeRitualColumn();
    }

    @Override
    @Nullable
    public ListEntries.CounterMaxEntry recreateElement(CompoundNBT tag, BlockPos pos) {
        return new ListEntries.CounterMaxEntry(pos, 1);
    }

    @Override
    @Nullable
    public ListEntries.CounterMaxEntry createElement(World world, BlockPos pos) {
        pos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos).func_177977_b();
        return new ListEntries.CounterMaxEntry(pos, 1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float alphaMultiplier, boolean extended) {
        ConstellationEffectProperties prop = this.createProperties(pedestal.getMirrorCount());
        Vector3 at = new Vector3((Vector3i)pos).add(0.5, 0.5, 0.5);
        at.addY(prop.getSize() * 0.75);
        int i = 0;
        while ((double)i < Math.max(1.0, prop.getSize() / 6.0)) {
            Vector3 vec = at.clone().add(Vector3.random().setY(0).multiply((double)rand.nextFloat() * prop.getSize()));
            Color c = (Color)MiscUtils.eitherOf(rand, () -> ColorsAS.CONSTELLATION_OCTANS, () -> ColorsAS.CONSTELLATION_OCTANS.darker());
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(vec)).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.constant(c))).setScaleMultiplier(0.6f + rand.nextFloat() * 0.3f)).setGravityStrength(4.0E-4f + rand.nextFloat() * 8.0E-4f)).setMaxAge(100 + rand.nextInt(60));
            ++i;
        }
    }

    @Override
    public boolean playEffect(World world, BlockPos pos, ConstellationEffectProperties properties, @Nullable IMinorConstellation trait) {
        if (!(world instanceof ServerWorld)) {
            return false;
        }
        boolean update = false;
        if (properties.isCorrupted()) {
            corruptedSkipWaterCheck = true;
            Either newEntry = this.peekNewPosition(world, pos, properties);
            corruptedSkipWaterCheck = false;
            return newEntry.mapLeft(entry -> {
                BlockState state = world.func_180495_p(entry.getPos());
                BlockPos offset = entry.getPos().func_177973_b((Vector3i)pos);
                if (world.func_175623_d(entry.getPos()) && (this.isLinkedRitual || Math.abs(offset.func_177958_n()) > 5 || Math.abs(offset.func_177952_p()) > 5 || offset.func_177956_o() < 0)) {
                    if (!world.func_230315_m_().func_236040_e_() && world.func_175656_a(entry.getPos(), Blocks.field_150355_j.func_176223_P())) {
                        for (int i = 0; i < 3; ++i) {
                            this.spawnFishingDropsAt((ServerWorld)world, entry.getPos());
                        }
                        world.func_190524_a(entry.getPos(), Blocks.field_150355_j, entry.getPos());
                    }
                } else if (BlockUtils.isFluidBlock(state)) {
                    if (state.func_177230_c() == Blocks.field_150355_j) {
                        if (rand.nextInt(100) == 0) {
                            this.spawnFishingDropsAt((ServerWorld)world, entry.getPos());
                        }
                    } else {
                        world.func_175656_a(entry.getPos(), Blocks.field_150354_m.func_176223_P());
                    }
                } else if (state.func_177230_c() instanceof BubbleColumnBlock && rand.nextInt(70) == 0) {
                    this.spawnFishingDropsAt((ServerWorld)world, entry.getPos());
                }
                return true;
            }).left().orElse(false);
        }
        ListEntries.CounterMaxEntry entry2 = (ListEntries.CounterMaxEntry)this.getRandomElementChanced();
        if (entry2 != null && MiscUtils.canEntityTickAt((IWorld)world, entry2.getPos())) {
            if (!this.isValid(world, entry2)) {
                this.removeElement(entry2);
            } else {
                this.sendConstellationPing(world, new Vector3((Vector3i)entry2.getPos()).add(0.5, 1.0, 0.5));
                int count = entry2.getCounter();
                entry2.setCounter(++count);
                if (count >= entry2.getMaxCount()) {
                    int min = Math.min((Integer)CEffectOctans.CONFIG.minFishTickTime.get(), (Integer)CEffectOctans.CONFIG.maxFishTickTime.get());
                    int max = Math.max((Integer)CEffectOctans.CONFIG.minFishTickTime.get(), (Integer)CEffectOctans.CONFIG.maxFishTickTime.get());
                    int diff = Math.max(1, max - min + 1);
                    entry2.setMaxCount(min + rand.nextInt(diff));
                    entry2.setCounter(0);
                    this.spawnFishingDropsAt((ServerWorld)world, entry2.getPos());
                }
            }
            update = true;
        }
        if (this.findNewPosition(world, pos, properties).ifRight(attemptedPos -> this.sendConstellationPing(world, new Vector3((Vector3i)world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, attemptedPos).func_177977_b()).add(0.5, 0.5, 0.5))).left().isPresent()) {
            update = true;
        }
        return update;
    }

    private void spawnFishingDropsAt(ServerWorld world, BlockPos pos) {
        Vector3 dropLoc = new Vector3((Vector3i)pos).add(0.5, 0.85, 0.5);
        ItemStack tool = new ItemStack((IItemProvider)Items.field_151112_aM);
        tool.func_77966_a(Enchantments.field_151370_z, 2);
        ResourceLocation fromTable = LootTables.field_186390_ao;
        if (rand.nextFloat() < 0.1f) {
            fromTable = LootTables.field_186389_an;
        }
        LootContext.Builder builder = new LootContext.Builder(world);
        builder.func_186469_a((float)rand.nextInt(2) * rand.nextFloat());
        builder.func_216023_a(rand);
        builder.func_216015_a(LootParameters.field_216289_i, (Object)tool);
        builder.func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos));
        LootTable lootTable = world.func_73046_m().func_200249_aQ().func_186521_a(fromTable);
        for (ItemStack loot : lootTable.func_216113_a(builder.func_216022_a(LootParameterSets.field_216262_c))) {
            ItemEntity ei = ItemUtils.dropItemNaturally((World)world, dropLoc.getX(), dropLoc.getY(), dropLoc.getZ(), loot);
            Vector3 motion = new Vector3(ei.func_213322_ci());
            motion.setY(Math.abs(motion.getY()));
            ei.func_213317_d(motion.toVector3d());
        }
    }

    @Override
    public ConstellationEffect.Config getConfig() {
        return CONFIG;
    }

    @Override
    public PlayerAffectionFlags.AffectionFlag getPlayerAffectionFlag() {
        return FLAG;
    }

    private static class OctansConfig
    extends CEffectAbstractList.CountConfig {
        private final int defaultMinFishTickTime = 20;
        private final int defaultMaxFishTickTime = 60;
        public ForgeConfigSpec.IntValue minFishTickTime;
        public ForgeConfigSpec.IntValue maxFishTickTime;

        public OctansConfig() {
            super("octans", 8.0, 1.0, 64);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.minFishTickTime = cfgBuilder.comment("Defines the minimum default tick-time until a fish may be fished by the ritual. Gets reduced internally the more starlight was provided at the ritual.").translation(this.translationKey("minFishTickTime")).defineInRange("minFishTickTime", this.defaultMinFishTickTime, 5, Integer.MAX_VALUE);
            this.maxFishTickTime = cfgBuilder.comment("Defines the maximum default tick-time until a fish may be fished by the ritual. Gets reduced internally the more starlight was provided at the ritual. Has to be bigger as the minimum time; if it isn't it'll be set to the minimum.").translation(this.translationKey("maxFishTickTime")).defineInRange("maxFishTickTime", this.defaultMaxFishTickTime, 10, Integer.MAX_VALUE);
        }
    }
}

