/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.infusedwood;

import hellfirepvp.astralsorcery.common.block.base.template.BlockInfusedWoodTemplate;
import hellfirepvp.astralsorcery.common.util.VoxelUtils;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockInfusedWoodColumn
extends BlockInfusedWoodTemplate
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final EnumProperty<PillarType> PILLAR_TYPE = EnumProperty.func_177709_a((String)"pillartype", PillarType.class);
    private final VoxelShape middleShape;
    private final VoxelShape bottomShape;
    private final VoxelShape topShape;

    public BlockInfusedWoodColumn() {
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(PILLAR_TYPE, (Comparable)((Object)PillarType.MIDDLE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.middleShape = this.createPillarShape();
        this.topShape = this.createPillarTopShape();
        this.bottomShape = this.createPillarBottomShape();
    }

    protected VoxelShape createPillarShape() {
        return Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    }

    protected VoxelShape createPillarTopShape() {
        VoxelShape column = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
        VoxelShape top = Block.func_208617_a((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        return VoxelUtils.combineAll(IBooleanFunction.field_223244_o_, column, top);
    }

    protected VoxelShape createPillarBottomShape() {
        VoxelShape column = Block.func_208617_a((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape bottom = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
        return VoxelUtils.combineAll(IBooleanFunction.field_223244_o_, column, bottom);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{PILLAR_TYPE, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        switch ((PillarType)((Object)state.func_177229_b(PILLAR_TYPE))) {
            case TOP: {
                return this.topShape;
            }
            case BOTTOM: {
                return this.bottomShape;
            }
        }
        return this.middleShape;
    }

    public BlockState func_196271_a(BlockState thisState, Direction otherBlockFacing, BlockState otherBlockState, IWorld world, BlockPos thisPos, BlockPos otherBlockPos) {
        if (((Boolean)thisState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(thisPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return (BlockState)this.getThisState((IBlockReader)world, thisPos).func_206870_a((Property)WATERLOGGED, thisState.func_177229_b((Property)WATERLOGGED));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockPos blockpos = ctx.func_195995_a();
        World world = ctx.func_195991_k();
        FluidState ifluidstate = world.func_204610_c(blockpos);
        return (BlockState)this.getThisState((IBlockReader)world, blockpos).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    private BlockState getThisState(IBlockReader world, BlockPos pos) {
        boolean hasUp = world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockInfusedWoodColumn;
        boolean hasDown = world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockInfusedWoodColumn;
        if (hasUp) {
            if (hasDown) {
                return (BlockState)this.func_176223_P().func_206870_a(PILLAR_TYPE, (Comparable)((Object)PillarType.MIDDLE));
            }
            return (BlockState)this.func_176223_P().func_206870_a(PILLAR_TYPE, (Comparable)((Object)PillarType.BOTTOM));
        }
        if (hasDown) {
            return (BlockState)this.func_176223_P().func_206870_a(PILLAR_TYPE, (Comparable)((Object)PillarType.TOP));
        }
        return (BlockState)this.func_176223_P().func_206870_a(PILLAR_TYPE, (Comparable)((Object)PillarType.MIDDLE));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.BLOCKED;
    }

    public static enum PillarType implements IStringSerializable
    {
        TOP,
        MIDDLE,
        BOTTOM;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

