/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.client.data.config.entry.RenderingConfig;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffect;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.fml.LogicalSide;

public class PatreonEffectHelper {
    static boolean loadingFinished = false;
    static Map<UUID, List<PatreonEffect>> playerEffectMap = new HashMap<UUID, List<PatreonEffect>>();
    static Map<UUID, PatreonEffect> effectMap = new HashMap<UUID, PatreonEffect>();

    @Nonnull
    public static List<PatreonEffect> getPatreonEffects(LogicalSide side, UUID playerUUID) {
        if (side.isClient() && !((Boolean)RenderingConfig.CONFIG.patreonEffects.get()).booleanValue()) {
            return Collections.emptyList();
        }
        if (!loadingFinished) {
            return Collections.emptyList();
        }
        return playerEffectMap.getOrDefault(playerUUID, Collections.emptyList());
    }

    @Nullable
    public static PatreonEffect getEffect(UUID effectUUID) {
        return effectMap.get(effectUUID);
    }

    public static <T extends PlayerEntity> Map<UUID, List<PatreonEffect>> getPatreonEffects(Collection<T> players) {
        if (!loadingFinished) {
            return Maps.newHashMap();
        }
        Collection playerUUIDs = players.stream().map(Entity::func_110124_au).collect(Collectors.toList());
        return playerEffectMap.entrySet().stream().filter(e -> playerUUIDs.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

