/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary;

import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.util.entity.EntityUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class AnimalHelper {
    private static final LinkedList<HerdableAnimal> animalHandlers = new LinkedList();

    public static void registerFirst(HerdableAnimal handler) {
        animalHandlers.addFirst(handler);
    }

    public static void register(HerdableAnimal handler) {
        animalHandlers.add(handler);
    }

    @Nullable
    public static HerdableAnimal getHandler(LivingEntity entity) {
        for (HerdableAnimal herd : animalHandlers) {
            if (!herd.handles(entity)) continue;
            return herd;
        }
        return null;
    }

    static {
        AnimalHelper.register(new Squid());
        AnimalHelper.register(new GenericAnimal());
    }

    public static class Squid
    extends GenericAnimal {
        @Override
        public boolean handles(@Nonnull LivingEntity entity) {
            return entity instanceof SquidEntity;
        }
    }

    public static class GenericAnimal
    implements HerdableAnimal {
        @Override
        public boolean handles(@Nonnull LivingEntity entity) {
            return entity instanceof AnimalEntity;
        }

        @Override
        public List<ItemStack> generateDrops(@Nonnull LivingEntity entity, World world, Random rand, float luck) {
            return EntityUtils.generateLoot(entity, rand, CommonProxy.DAMAGE_SOURCE_STELLAR, null);
        }
    }

    public static interface HerdableAnimal {
        public boolean handles(@Nonnull LivingEntity var1);

        public List<ItemStack> generateDrops(@Nonnull LivingEntity var1, World var2, Random var3, float var4);
    }
}

