/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal.page;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.render.IDrawRenderTypeBuffer;
import hellfirepvp.astralsorcery.client.resource.BlockAtlasTexture;
import hellfirepvp.astralsorcery.client.screen.journal.page.RenderablePage;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import hellfirepvp.observerlib.api.block.MatchableState;
import hellfirepvp.observerlib.api.client.StructureRenderer;
import hellfirepvp.observerlib.api.structure.Structure;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;

public class RenderPageStructure
extends RenderablePage {
    private final StructureRenderer structureRenderer;
    private final Structure structure;
    private final Vector3 shift;
    private final List<Tuple<ItemStack, ITextProperties>> contentStacks;
    private final ITextProperties name;
    private Optional<Integer> drawSlice = Optional.empty();
    private Rectangle2D.Float switchView = null;
    private Rectangle2D.Float sliceUp = null;
    private Rectangle2D.Float sliceDown = null;
    private Rectangle2D.Float switchRequiredAir = null;
    private long totalRenderFrame = 0L;
    private boolean showAirBlocks = false;

    public RenderPageStructure(@Nullable ResearchNode node, int nodePage, Structure structure, @Nullable ITextProperties name, @Nonnull Vector3 shift) {
        super(node, nodePage);
        this.structure = structure;
        this.structureRenderer = new StructureRenderer(this.structure).setIsolateIndividualBlock(true);
        this.name = name;
        this.shift = shift;
        this.contentStacks = new ArrayList<Tuple<ItemStack, ITextProperties>>();
        structure.getAsStacks((IBlockReader)this.structureRenderer.getRenderWorld(), (PlayerEntity)Minecraft.func_71410_x().field_71439_g).forEach(stack -> {
            ItemStack display = ItemUtils.copyStackWithSize(stack, 1);
            IFormattableTextComponent description = new StringTextComponent(stack.func_190916_E() + "x ").func_230529_a_(stack.func_200301_q());
            this.contentStacks.add((Tuple<ItemStack, ITextProperties>)new Tuple((Object)display, (Object)description));
        });
    }

    @Override
    public void render(MatrixStack renderStack, float x, float y, float z, float pTicks, float mouseX, float mouseY) {
        ++this.totalRenderFrame;
        this.renderStructure(renderStack, x, y, pTicks);
        float shift = this.renderSizeDescription(renderStack, x, y + 5.0f, z);
        if (this.name != null) {
            this.renderHeadline(renderStack, x + shift, y + 5.0f, z, this.name);
        }
        this.renderSliceButtons(renderStack, x, y + 10.0f, z, mouseX, mouseY);
    }

    private void renderSliceButtons(MatrixStack renderStack, float offsetX, float offsetY, float zLevel, float mouseX, float mouseY) {
        TexturesAS.TEX_GUI_BOOK_STRUCTURE_ICONS.bindTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.switchView = null;
        this.sliceDown = null;
        this.sliceUp = null;
        this.switchRequiredAir = null;
        this.switchView = new Rectangle2D.Float(offsetX + 152.0f, offsetY + 10.0f, 16.0f, 16.0f);
        float u = this.drawSlice.isPresent() ? 0.5f : 0.0f;
        RenderingGuiUtils.drawTexturedRect(renderStack, this.switchView.x, this.switchView.y, zLevel, this.switchView.width, this.switchView.height, u, 0.0f, 0.5f, 0.25f);
        if (this.drawSlice.isPresent()) {
            float v;
            int yLevel = this.drawSlice.get();
            int minSlice = this.getCurrentMinSlice();
            int maxSlice = this.getCurrentMaxSlice();
            if (yLevel < minSlice) {
                yLevel = maxSlice;
            }
            if (yLevel > maxSlice) {
                yLevel = maxSlice;
            }
            if (minSlice <= yLevel - 1) {
                this.sliceDown = new Rectangle2D.Float(offsetX + 160.0f, offsetY + 28.0f, 11.0f, 16.0f);
                renderStack.func_227860_a_();
                renderStack.func_227861_a_((double)(this.sliceDown.x + this.sliceDown.width / 2.0f), (double)(this.sliceDown.y + this.sliceDown.height / 2.0f), (double)zLevel);
                v = 0.5f;
                if (this.sliceDown.contains(mouseX, mouseY)) {
                    v = 0.25f;
                    renderStack.func_227862_a_(1.1f, 1.1f, 1.0f);
                }
                renderStack.func_227861_a_((double)(-this.sliceDown.width / 2.0f), (double)(-this.sliceDown.height / 2.0f), 0.0);
                RenderingGuiUtils.drawTexturedRect(renderStack, this.sliceDown.width, this.sliceDown.height, 0.375f, v, 0.34375f, 0.25f);
                renderStack.func_227865_b_();
            }
            if (maxSlice >= yLevel + 1) {
                this.sliceUp = new Rectangle2D.Float(offsetX + 148.0f, offsetY + 28.0f, 11.0f, 16.0f);
                renderStack.func_227860_a_();
                renderStack.func_227861_a_((double)(this.sliceUp.x + this.sliceUp.width / 2.0f), (double)(this.sliceUp.y + this.sliceUp.height / 2.0f), (double)zLevel);
                v = 0.5f;
                if (this.sliceUp.contains(mouseX, mouseY)) {
                    v = 0.25f;
                    renderStack.func_227862_a_(1.1f, 1.1f, 1.0f);
                }
                renderStack.func_227861_a_((double)(-this.sliceUp.width / 2.0f), (double)(-this.sliceUp.height / 2.0f), 0.0);
                RenderingGuiUtils.drawTexturedRect(renderStack, this.sliceUp.width, this.sliceUp.height, 0.0f, v, 0.34375f, 0.25f);
                renderStack.func_227865_b_();
            }
        }
        this.switchRequiredAir = new Rectangle2D.Float(offsetX + 134.0f, offsetY + 10.0f, 16.0f, 16.0f);
        RenderingGuiUtils.drawTexturedRect(renderStack, this.switchRequiredAir.x, this.switchRequiredAir.y, zLevel, this.switchRequiredAir.width, this.switchRequiredAir.height, 0.0f, 0.75f, 0.5f, 0.25f);
        if (this.showAirBlocks) {
            BlockAtlasTexture.getInstance().bindTexture();
            RenderSystem.depthMask((boolean)false);
            RenderingUtils.draw(7, DefaultVertexFormats.field_176600_a, buf -> {
                renderStack.func_227860_a_();
                renderStack.func_227861_a_((double)(this.switchRequiredAir.x + 13.0f), (double)(this.switchRequiredAir.y + 11.0f), (double)(zLevel + 60.0f));
                renderStack.func_227862_a_(7.0f, -7.0f, 7.0f);
                renderStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(30.0f));
                renderStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(225.0f));
                RenderingUtils.renderSimpleBlockModel(Blocks.field_196824_gy.func_176223_P(), renderStack, (IVertexBuilder)buf);
                renderStack.func_227865_b_();
            });
            RenderSystem.depthMask((boolean)true);
        }
        RenderSystem.disableBlend();
    }

    private int getCurrentMinSlice() {
        int minSlice = this.structure.getMinimumOffset().func_177956_o();
        if (!this.showAirBlocks) {
            for (int yy = minSlice; yy <= this.structure.getMaximumOffset().func_177956_o(); ++yy) {
                boolean onlyAir = this.structure.getStructureSlice(yy).stream().allMatch(tpl -> ((MatchableState)tpl.func_76340_b()).equals(MatchableState.REQUIRES_AIR));
                if (onlyAir) continue;
                return yy;
            }
        }
        return minSlice;
    }

    private int getCurrentMaxSlice() {
        int maxSlice = this.structure.getMaximumOffset().func_177956_o();
        if (!this.showAirBlocks) {
            for (int yy = maxSlice; yy >= this.structure.getMinimumOffset().func_177956_o(); --yy) {
                boolean onlyAir = this.structure.getStructureSlice(yy).stream().allMatch(tpl -> ((MatchableState)tpl.func_76340_b()).equals(MatchableState.REQUIRES_AIR));
                if (onlyAir) continue;
                return yy;
            }
        }
        return maxSlice;
    }

    private void renderHeadline(MatrixStack renderStack, float offsetX, float offsetY, float zLevel, ITextProperties title) {
        float scale = 1.3f;
        RenderSystem.disableDepthTest();
        renderStack.func_227860_a_();
        renderStack.func_227861_a_((double)offsetX, (double)offsetY, (double)zLevel);
        renderStack.func_227862_a_(scale, scale, scale);
        RenderingDrawUtils.renderStringAt(title, renderStack, null, 0xDDDDDD, true);
        renderStack.func_227865_b_();
        RenderSystem.enableDepthTest();
    }

    private float renderSizeDescription(MatrixStack renderStack, float offsetX, float offsetY, float zLevel) {
        Vector3 size = new Vector3(this.structure.getMaximumOffset()).subtract(this.structure.getMinimumOffset()).add(1.0f, 1.0f, 1.0f);
        FontRenderer fr = RenderablePage.getFontRenderer();
        float scale = 1.3f;
        StringTextComponent description = new StringTextComponent(String.format("%s - %s - %s", size.getBlockX(), size.getBlockY(), size.getBlockZ()));
        float length = (float)fr.func_238414_a_((ITextProperties)description) * scale;
        RenderSystem.disableDepthTest();
        renderStack.func_227860_a_();
        renderStack.func_227861_a_((double)offsetX, (double)offsetY, (double)zLevel);
        renderStack.func_227862_a_(scale, scale, scale);
        RenderingDrawUtils.renderStringAt((ITextProperties)description, renderStack, fr, 0xDDDDDD, true);
        renderStack.func_227865_b_();
        this.drawSlice.ifPresent(yLevel -> {
            int min = this.getCurrentMinSlice();
            int max = this.getCurrentMaxSlice();
            int height = max - min;
            int level = yLevel - min;
            StringTextComponent slice = new StringTextComponent(String.format("%s / %s", level + 1, height + 1));
            renderStack.func_227860_a_();
            renderStack.func_227861_a_((double)offsetX, (double)(offsetY + 14.0f), (double)zLevel);
            renderStack.func_227862_a_(scale, scale, scale);
            RenderingDrawUtils.renderStringAt((ITextProperties)slice, renderStack, fr, 0xDDDDDD, true);
            renderStack.func_227865_b_();
        });
        RenderSystem.enableDepthTest();
        return length + 8.0f;
    }

    private void renderStructure(MatrixStack renderStack, float offsetX, float offsetY, float pTicks) {
        Point2D.Double renderOffset = this.renderOffset(offsetX + 8.0f, offsetY);
        this.structureRenderer.setRenderWithRequiredAir(this.showAirBlocks);
        this.structureRenderer.render3DSliceGUI(renderStack, renderOffset.x + this.shift.getX(), renderOffset.y + this.shift.getY(), pTicks, this.drawSlice);
        this.structureRenderer.setRenderWithRequiredAir(false);
    }

    private Point2D.Double renderOffset(float stdPageOffsetX, float stdPageOffsetY) {
        return new Point2D.Double((double)stdPageOffsetX + 78.75, (double)stdPageOffsetY + 132.0);
    }

    @Override
    public void postRender(MatrixStack renderStack, float x, float y, float z, float pTicks, float mouseX, float mouseY) {
        TranslationTextComponent switchInfo;
        renderStack.func_227860_a_();
        renderStack.func_227861_a_((double)(x + 160.0f), (double)(y + 10.0f), (double)z);
        Rectangle rect = RenderingDrawUtils.drawInfoStar(renderStack, IDrawRenderTypeBuffer.defaultBuffer(), 15.0f, pTicks);
        rect.translate((int)(x + 160.0f), (int)(y + 10.0f));
        renderStack.func_227865_b_();
        if (rect.contains(mouseX, mouseY)) {
            RenderingDrawUtils.renderBlueTooltip(renderStack, x + 160.0f, y + 10.0f, z + 650.0f, this.contentStacks, RenderablePage.getFontRenderer(), false);
        }
        if (this.switchView != null && this.switchView.contains(mouseX, mouseY)) {
            switchInfo = new TranslationTextComponent("astralsorcery.journal.structure.switch_view");
            RenderingDrawUtils.renderBlueTooltipComponents(renderStack, this.switchView.x + this.switchView.width / 2.0f, this.switchView.y + this.switchView.height / 2.0f, z + 500.0f, Lists.newArrayList((Object[])new ITextProperties[]{switchInfo}), RenderablePage.getFontRenderer(), false);
        }
        if (this.switchRequiredAir != null && this.switchRequiredAir.contains(mouseX, mouseY)) {
            switchInfo = new TranslationTextComponent("astralsorcery.journal.structure.required_air");
            RenderingDrawUtils.renderBlueTooltipComponents(renderStack, this.switchRequiredAir.x + this.switchRequiredAir.width / 2.0f, this.switchRequiredAir.y + this.switchRequiredAir.height / 2.0f, z + 500.0f, Lists.newArrayList((Object[])new ITextProperties[]{switchInfo}), RenderablePage.getFontRenderer(), false);
        }
    }

    @Override
    public boolean propagateMouseDrag(double mouseDX, double mouseDZ) {
        this.structureRenderer.rotateFromMouseDrag((float)mouseDX, (float)mouseDZ);
        return true;
    }

    @Override
    public boolean propagateMouseClick(double mouseX, double mouseZ) {
        if (this.switchView != null && this.switchView.contains(mouseX, mouseZ)) {
            this.drawSlice = this.drawSlice.isPresent() ? Optional.empty() : Optional.of(this.getCurrentMinSlice());
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        if (this.sliceUp != null && this.drawSlice.isPresent() && this.sliceUp.contains(mouseX, mouseZ)) {
            this.drawSlice = Optional.of(this.drawSlice.get() + 1);
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        if (this.sliceDown != null && this.drawSlice.isPresent() && this.sliceDown.contains(mouseX, mouseZ)) {
            this.drawSlice = Optional.of(this.drawSlice.get() - 1);
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        if (this.switchRequiredAir != null && this.switchRequiredAir.contains(mouseX, mouseZ)) {
            boolean bl = this.showAirBlocks = !this.showAirBlocks;
            if (this.drawSlice.isPresent()) {
                int yLevel = this.drawSlice.get();
                int minSlice = this.getCurrentMinSlice();
                int maxSlice = this.getCurrentMaxSlice();
                if (yLevel < minSlice) {
                    yLevel = maxSlice;
                }
                if (yLevel > maxSlice) {
                    yLevel = maxSlice;
                }
                this.drawSlice = Optional.of(yLevel);
            }
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

