/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.render.entity.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import hellfirepvp.astralsorcery.client.registry.RegistryRenderTypes;
import hellfirepvp.astralsorcery.common.util.object.CacheReference;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;

public class StarryLayerRenderer<E extends LivingEntity, M extends BipedModel<E>>
extends BipedArmorLayer<E, M, BipedModel<E>> {
    private static final List<CacheReference<RenderType>> RENDER_TYPES = IntStream.range(0, 2).mapToObj(i -> new CacheReference<RenderType>(() -> RegistryRenderTypes.createDepthProjectionType(i))).collect(Collectors.toList());
    private static final BipedModel MODEL_HEAD = new PlayerModel(-0.5f, false);
    private static final BipedModel MODEL_ARMOR = new PlayerModel(0.0f, false);
    private static final BipedModel MODEL_ARMOR_SMALL = new PlayerModel(0.0f, true);
    private static BiPredicate<PlayerEntity, EquipmentSlotType> renderTest = (p, type) -> false;
    private final boolean slimRender;

    public StarryLayerRenderer(IEntityRenderer<E, M> entityRendererIn, boolean slimRender) {
        super(entityRendererIn, MODEL_ARMOR, MODEL_ARMOR);
        this.slimRender = slimRender;
    }

    public static void addRender(BiPredicate<PlayerEntity, EquipmentSlotType> render) {
        renderTest = renderTest.or(render);
    }

    public void func_225628_a_(MatrixStack renderStack, IRenderTypeBuffer buffer, int light, E entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        for (EquipmentSlotType slotType : EquipmentSlotType.values()) {
            if (slotType.func_188453_a() != EquipmentSlotType.Group.ARMOR || !renderTest.test((PlayerEntity)entity, slotType)) continue;
            BipedModel model = slotType == EquipmentSlotType.HEAD ? MODEL_HEAD : (this.slimRender ? MODEL_ARMOR_SMALL : MODEL_ARMOR);
            this.renderArmorPart(renderStack, buffer, slotType, light, model);
        }
    }

    private void renderArmorPart(MatrixStack renderStack, IRenderTypeBuffer buffer, EquipmentSlotType slotType, int light, BipedModel<E> model) {
        ((BipedModel)this.func_215332_c()).func_217148_a(model);
        this.func_188359_a(model, slotType);
        for (CacheReference<RenderType> renderType : RENDER_TYPES) {
            model.func_225598_a_(renderStack, buffer.getBuffer(renderType.get()), light, OverlayTexture.field_229196_a_, 0.4f, 0.4f, 1.0f, 0.1f);
        }
    }
}

