/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonBook;
import vazkii.patchouli.common.book.Book;

public class GuiButtonBookMarkRead
extends GuiButtonBook {
    private final Book book;

    public GuiButtonBookMarkRead(GuiBook parent, int x, int y) {
        super(parent, x, y, 308, 31, 11, 11, Button::func_230930_b_, GuiButtonBookMarkRead.getTooltip(parent.book));
        this.book = parent.book;
    }

    @Override
    public void func_230431_b_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        int px = this.field_230690_l_ + 1;
        int py = (int)((double)this.field_230691_m_ + 0.5);
        GuiBook.drawFromTexture(ms, this.book, this.field_230690_l_, this.field_230691_m_, 285, 160, 13, 10);
        GuiBook.drawFromTexture(ms, this.book, px, py, this.u, this.v, this.field_230688_j_, this.field_230689_k_);
        if (this.func_230449_g_()) {
            GuiBook.drawFromTexture(ms, this.book, px, py, this.u + 11, this.v, this.field_230688_j_, this.field_230689_k_);
            this.parent.setTooltip(this.getTooltip());
        }
        this.parent.getMinecraft().field_71466_p.func_238405_a_(ms, "+", (float)px - 0.5f, (float)py - 0.2f, 65281);
    }

    public void func_230930_b_() {
        for (BookEntry entry : this.book.contents.entries.values()) {
            if (GuiButtonBookMarkRead.isMainPage(this.book)) {
                this.markEntry(entry);
                continue;
            }
            this.markCategoryAsRead(entry, entry.getCategory(), this.book.contents.entries.size());
        }
    }

    private void markCategoryAsRead(BookEntry entry, BookCategory category, int maxRecursion) {
        if (category.getName().equals(this.book.contents.getCurrentGui().func_231171_q_())) {
            this.markEntry(entry);
        } else if (!category.isRootCategory() && maxRecursion > 0) {
            this.markCategoryAsRead(entry, entry.getCategory().getParentCategory(), maxRecursion - 1);
        }
    }

    private void markEntry(BookEntry entry) {
        boolean dirty = false;
        String key = entry.getId().toString();
        if (!entry.isLocked() && entry.getReadState().equals((Object)EntryDisplayState.UNREAD)) {
            PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(this.book);
            if (!data.viewedEntries.contains(key)) {
                data.viewedEntries.add(key);
                dirty = true;
                entry.markReadStateDirty();
            }
        }
        if (dirty) {
            PersistentData.save();
        }
    }

    private static ITextComponent getTooltip(Book book) {
        String text = GuiButtonBookMarkRead.isMainPage(book) ? "patchouli.gui.lexicon.button.mark_all_read" : "patchouli.gui.lexicon.button.mark_category_read";
        return new TranslationTextComponent(text);
    }

    private static boolean isMainPage(Book book) {
        return !book.contents.currentGui.canSeeBackButton();
    }
}

