/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.repack.registrate.providers;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import team.chisel.repack.registrate.AbstractRegistrate;
import team.chisel.repack.registrate.providers.RegistrateAdvancementProvider;
import team.chisel.repack.registrate.providers.RegistrateBlockstateProvider;
import team.chisel.repack.registrate.providers.RegistrateDataProvider;
import team.chisel.repack.registrate.providers.RegistrateItemModelProvider;
import team.chisel.repack.registrate.providers.RegistrateItemTagsProvider;
import team.chisel.repack.registrate.providers.RegistrateLangProvider;
import team.chisel.repack.registrate.providers.RegistrateProvider;
import team.chisel.repack.registrate.providers.RegistrateRecipeProvider;
import team.chisel.repack.registrate.providers.RegistrateTagsProvider;
import team.chisel.repack.registrate.providers.loot.RegistrateLootTableProvider;
import team.chisel.repack.registrate.util.nullness.FieldsAreNonnullByDefault;
import team.chisel.repack.registrate.util.nullness.NonNullBiFunction;
import team.chisel.repack.registrate.util.nullness.NonNullFunction;
import team.chisel.repack.registrate.util.nullness.NonNullUnaryOperator;

@FunctionalInterface
@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public interface ProviderType<T extends RegistrateProvider> {
    public static final ProviderType<RegistrateRecipeProvider> RECIPE = ProviderType.register("recipe", (AbstractRegistrate<?> p, GatherDataEvent e) -> new RegistrateRecipeProvider((AbstractRegistrate<?>)p, e.getGenerator()));
    public static final ProviderType<RegistrateAdvancementProvider> ADVANCEMENT = ProviderType.register("advancement", (AbstractRegistrate<?> p, GatherDataEvent e) -> new RegistrateAdvancementProvider((AbstractRegistrate<?>)p, e.getGenerator()));
    public static final ProviderType<RegistrateLootTableProvider> LOOT = ProviderType.register("loot", (AbstractRegistrate<?> p, GatherDataEvent e) -> new RegistrateLootTableProvider((AbstractRegistrate<?>)p, e.getGenerator()));
    public static final ProviderType<RegistrateTagsProvider<Block>> BLOCK_TAGS = ProviderType.register("tags/block", (ProviderType<T> type) -> (p, e) -> new RegistrateTagsProvider((AbstractRegistrate<?>)p, type, "blocks", e.getGenerator(), Registry.field_212618_g, e.getExistingFileHelper()));
    public static final ProviderType<RegistrateItemTagsProvider> ITEM_TAGS = ProviderType.registerDelegate("tags/item", type -> (p, e, existing) -> new RegistrateItemTagsProvider((AbstractRegistrate<?>)p, (ProviderType<RegistrateItemTagsProvider>)type, "items", e.getGenerator(), e.getExistingFileHelper(), (RegistrateTagsProvider)existing.get(BLOCK_TAGS)));
    public static final ProviderType<RegistrateTagsProvider<Fluid>> FLUID_TAGS = ProviderType.register("tags/fluid", (ProviderType<T> type) -> (p, e) -> new RegistrateTagsProvider((AbstractRegistrate<?>)p, type, "fluids", e.getGenerator(), Registry.field_212619_h, e.getExistingFileHelper()));
    public static final ProviderType<RegistrateTagsProvider<EntityType<?>>> ENTITY_TAGS = ProviderType.register("tags/entity", (ProviderType<T> type) -> (p, e) -> new RegistrateTagsProvider((AbstractRegistrate<?>)p, type, "entity_types", e.getGenerator(), Registry.field_212629_r, e.getExistingFileHelper()));
    public static final ProviderType<RegistrateBlockstateProvider> BLOCKSTATE = ProviderType.register("blockstate", (AbstractRegistrate<?> p, GatherDataEvent e) -> new RegistrateBlockstateProvider((AbstractRegistrate<?>)p, e.getGenerator(), e.getExistingFileHelper()));
    public static final ProviderType<RegistrateItemModelProvider> ITEM_MODEL = ProviderType.register("item_model", (AbstractRegistrate<?> p, GatherDataEvent e, Map<ProviderType<?>, RegistrateProvider> existing) -> new RegistrateItemModelProvider(p, e.getGenerator(), ((RegistrateBlockstateProvider)existing.get(BLOCKSTATE)).getExistingFileHelper()));
    public static final ProviderType<RegistrateLangProvider> LANG = ProviderType.register("lang", (AbstractRegistrate<?> p, GatherDataEvent e) -> new RegistrateLangProvider((AbstractRegistrate<?>)p, e.getGenerator()));

    public T create(AbstractRegistrate<?> var1, GatherDataEvent var2, Map<ProviderType<?>, RegistrateProvider> var3);

    @Nonnull
    public static <T extends RegistrateProvider> ProviderType<T> registerDelegate(String name, final NonNullUnaryOperator<ProviderType<T>> type) {
        ProviderType ret = new ProviderType<T>(){

            @Override
            public T create(@Nonnull AbstractRegistrate<?> parent, GatherDataEvent event, Map<ProviderType<?>, RegistrateProvider> existing) {
                return ((ProviderType)type.apply(this)).create(parent, event, existing);
            }
        };
        return ProviderType.register(name, ret);
    }

    @Nonnull
    public static <T extends RegistrateProvider> ProviderType<T> register(String name, final NonNullFunction<ProviderType<T>, NonNullBiFunction<AbstractRegistrate<?>, GatherDataEvent, T>> type) {
        ProviderType ret = new ProviderType<T>(){

            @Override
            public T create(@Nonnull AbstractRegistrate<?> parent, GatherDataEvent event, Map<ProviderType<?>, RegistrateProvider> existing) {
                return (RegistrateProvider)((NonNullBiFunction)type.apply(this)).apply(parent, event);
            }
        };
        return ProviderType.register(name, ret);
    }

    @Nonnull
    public static <T extends RegistrateProvider> ProviderType<T> register(String name, final NonNullBiFunction<AbstractRegistrate<?>, GatherDataEvent, T> type) {
        ProviderType ret = new ProviderType<T>(){

            @Override
            public T create(AbstractRegistrate<?> parent, GatherDataEvent event, Map<ProviderType<?>, RegistrateProvider> existing) {
                return (RegistrateProvider)type.apply(parent, event);
            }
        };
        return ProviderType.register(name, ret);
    }

    @Nonnull
    public static <T extends RegistrateProvider> ProviderType<T> register(String name, ProviderType<T> type) {
        RegistrateDataProvider.TYPES.put((Object)name, type);
        return type;
    }
}

