/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import team.chisel.common.config.Configurations;
import team.chisel.common.init.ChiselItems;
import team.chisel.common.inventory.ContainerAutoChisel;

public class GuiAutoChisel
extends ContainerScreen<ContainerAutoChisel> {
    @Nonnull
    private static final ResourceLocation TEXTURE = new ResourceLocation("chisel", "textures/autochisel.png");
    private static final int PROG_BAR_LENGTH = 50;
    private static final int POWER_BAR_LENGTH = 160;
    private final ContainerAutoChisel container;
    @Nonnull
    private final ItemStack fakeChisel = new ItemStack((IItemProvider)ChiselItems.IRON_CHISEL.get());

    public GuiAutoChisel(ContainerAutoChisel container, PlayerInventory inv, ITextComponent displayName) {
        super((Container)container, inv, displayName);
        this.container = container;
        this.field_147000_g = 200;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.container.isActive()) {
            int scaledProg = this.container.getProgressScaled(50);
            this.func_238474_b_(matrixStack, this.field_147003_i + 63, this.field_147009_r + 19 + 9, 176, 18, scaledProg + 1, 16);
        }
        if (Configurations.autoChiselPowered) {
            this.func_238474_b_(matrixStack, this.field_147003_i + 7, this.field_147009_r + 93, 7, 200, 162, 6);
            if (this.container.hasEnergy()) {
                this.func_238474_b_(matrixStack, this.field_147003_i + 8, this.field_147009_r + 94, 8, 206, this.container.getEnergyScaled(160) + 1, 4);
            }
        }
        if (!this.container.func_75139_a(this.container.chiselSlot).func_75216_d()) {
            this.drawGhostItem(matrixStack, this.fakeChisel, this.field_147003_i + 80, this.field_147009_r + 28);
        }
        if (!this.container.func_75139_a(this.container.targetSlot).func_75216_d()) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_238474_b_(matrixStack, this.field_147003_i + 80, this.field_147009_r + 64, 176, 34, 16, 16);
        }
    }

    private void drawGhostItem(MatrixStack matrixStack, @Nonnull ItemStack stack, int x, int y) {
        Minecraft.func_71410_x().func_175599_af().func_175042_a(stack, x, y);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.disableLighting();
        this.func_238474_b_(matrixStack, x, y, x - this.field_147003_i, y - this.field_147009_r, 16, 16);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_) / 2), 6.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrixStack, this.container.invPlayer.func_145748_c_(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        if (Configurations.autoChiselPowered) {
            int finalMouseX = mouseX -= this.field_147003_i;
            int finalMouseY = mouseY -= this.field_147009_r;
            if (finalMouseX >= 7 && finalMouseY >= 93 && finalMouseX <= 169 && finalMouseY <= 98) {
                NumberFormat fmt = NumberFormat.getNumberInstance();
                String stored = fmt.format(this.container.getEnergy());
                String max = fmt.format(this.container.getMaxEnergy());
                ArrayList tt = Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("chisel.tooltip.power.stored", new Object[]{stored, max}), new TranslationTextComponent("chisel.tooltip.power.pertick", new Object[]{fmt.format(this.container.getUsagePerTick())}).func_240699_a_(TextFormatting.GRAY)});
                this.func_243308_b(matrixStack, tt, finalMouseX, finalMouseY);
            }
        }
    }
}

