/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.utils;

import com.infamous.dungeons_libraries.capabilities.minionmaster.IMaster;
import com.infamous.dungeons_libraries.capabilities.minionmaster.IMinion;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionMasterHelper;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;

public class PetHelper {
    public static void makeNearbyPetsAttackTarget(LivingEntity target, LivingEntity owner) {
        if (PetHelper.isPetOf(target, owner) || PetHelper.isPetOf(owner, target)) {
            return;
        }
        IMaster masterCapability = MinionMasterHelper.getMasterCapability((Entity)owner);
        if (masterCapability == null) {
            return;
        }
        List nearbyEntities = owner.func_130014_f_().func_225316_b(LivingEntity.class, owner.func_174813_aQ().func_186662_g(12.0), nearbyEntity -> PetHelper.isPetOf(owner, nearbyEntity));
        HashSet pets = new HashSet();
        pets.addAll(nearbyEntities);
        for (LivingEntity pet : pets) {
            if (pet instanceof TameableEntity) {
                TameableEntity tameableEntity = (TameableEntity)pet;
                tameableEntity.func_70624_b(target);
            }
            if (pet instanceof LlamaEntity) {
                LlamaEntity llamaEntity = (LlamaEntity)pet;
                llamaEntity.func_70624_b(target);
            }
            if (!(pet instanceof IronGolemEntity)) continue;
            IronGolemEntity ironGolemEntity = (IronGolemEntity)pet;
            ironGolemEntity.func_70624_b(target);
        }
    }

    public static boolean canPetAttackEntity(LivingEntity master, LivingEntity pet, LivingEntity target) {
        return pet != target && pet.func_70089_S() && !PetHelper.isPetOrColleagueRelation(pet, target) && (master instanceof PlayerEntity && !PetHelper.isPetOfPlayer(target) || !(master instanceof PlayerEntity) && (target instanceof PlayerEntity || PetHelper.isPetOfPlayer(target)));
    }

    private static boolean isPetOfPlayer(LivingEntity target) {
        IMinion minionCapability = MinionMasterHelper.getMinionCapability((Entity)target);
        if (minionCapability == null) {
            return false;
        }
        if (minionCapability.getMaster() == null) {
            return false;
        }
        PlayerEntity playerByUUID = target.field_70170_p.func_217371_b(minionCapability.getMaster());
        return playerByUUID != null;
    }

    public static boolean isPetOf(LivingEntity possibleOwner, LivingEntity possiblePet) {
        if (possiblePet instanceof TameableEntity) {
            TameableEntity pet = (TameableEntity)possiblePet;
            return pet.func_70902_q() == possibleOwner;
        }
        if (possiblePet instanceof AbstractHorseEntity) {
            AbstractHorseEntity horse = (AbstractHorseEntity)possiblePet;
            return horse.func_184780_dh() == possibleOwner.func_110124_au();
        }
        return MinionMasterHelper.isMinionOf(possiblePet, possibleOwner.func_110124_au());
    }

    public static boolean isPetOrColleagueRelation(LivingEntity potentialPet1, LivingEntity potentialPet2) {
        LivingEntity owner = null;
        owner = potentialPet1 instanceof TameableEntity ? ((TameableEntity)potentialPet1).func_70902_q() : (potentialPet1 instanceof AbstractHorseEntity ? MinionMasterHelper.getOwnerForHorse((AbstractHorseEntity)potentialPet1) : MinionMasterHelper.getMaster(potentialPet1));
        LivingEntity otherOwner = null;
        otherOwner = potentialPet2 instanceof TameableEntity ? ((TameableEntity)potentialPet2).func_70902_q() : (potentialPet2 instanceof AbstractHorseEntity ? MinionMasterHelper.getOwnerForHorse((AbstractHorseEntity)potentialPet2) : MinionMasterHelper.getMaster(potentialPet2));
        if (owner == null) {
            return potentialPet1 == otherOwner;
        }
        if (otherOwner == null) {
            return potentialPet2 == owner;
        }
        return owner == otherOwner;
    }
}

