/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.network;

import com.infamous.dungeons_libraries.capabilities.soulcaster.ISoulCaster;
import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCasterHelper;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateSoulsMessage {
    private final float newAmount;

    public UpdateSoulsMessage(float souls) {
        this.newAmount = souls;
    }

    public static void encode(UpdateSoulsMessage packet, PacketBuffer buf) {
        buf.writeFloat(packet.newAmount);
    }

    public static UpdateSoulsMessage decode(PacketBuffer buf) {
        return new UpdateSoulsMessage(buf.readFloat());
    }

    public static class UpdateSoulsHandler {
        public static void handle(final UpdateSoulsMessage packet, Supplier<NetworkEvent.Context> ctx) {
            if (packet != null) {
                ctx.get().setPacketHandled(true);
                ctx.get().enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> new DistExecutor.SafeRunnable(){
                    private static final long serialVersionUID = 1L;

                    public void run() {
                        ISoulCaster soulCasterCap;
                        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                        if (player != null && (soulCasterCap = SoulCasterHelper.getSoulCasterCapability((Entity)player)) != null) {
                            soulCasterCap.setSouls(packet.newAmount, (LivingEntity)player);
                        }
                    }
                }));
            }
        }
    }
}

