/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class BuiltInEnchantmentsMessage {
    private int entityId;
    private ResourceLocation resourceLocation;
    private List<EnchantmentData> enchantmentDataList;

    public BuiltInEnchantmentsMessage(int entityId, ResourceLocation resourceLocation, List<EnchantmentData> enchantmentDataList) {
        this.entityId = entityId;
        this.resourceLocation = resourceLocation;
        this.enchantmentDataList = enchantmentDataList;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.func_192572_a(this.resourceLocation);
        buffer.func_150787_b(this.enchantmentDataList.size());
        this.enchantmentDataList.forEach(enchantmentData -> {
            buffer.func_192572_a(enchantmentData.field_76302_b.getRegistryName());
            buffer.writeInt(enchantmentData.field_76303_c);
        });
    }

    public static BuiltInEnchantmentsMessage decode(PacketBuffer buffer) {
        int entityId = buffer.readInt();
        ResourceLocation resourceLocation = buffer.func_192575_l();
        ArrayList<EnchantmentData> enchantmentData = new ArrayList<EnchantmentData>();
        int length = buffer.func_150792_a();
        for (int x = 0; x < length; ++x) {
            enchantmentData.add(new EnchantmentData((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(buffer.func_192575_l()), buffer.readInt()));
        }
        return new BuiltInEnchantmentsMessage(entityId, resourceLocation, enchantmentData);
    }

    public static boolean onPacketReceived(BuiltInEnchantmentsMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        return true;
    }
}

