/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.gearconfig;

import com.infamous.dungeons_libraries.DungeonsLibraries;
import com.infamous.dungeons_libraries.data.util.CodecJsonDataManager;
import com.infamous.dungeons_libraries.items.gearconfig.GearConfigReload;
import com.infamous.dungeons_libraries.items.gearconfig.MeleeGearConfig;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_libraries", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GearConfigRegistry {
    public static final ResourceLocation GEAR_CONFIG_BUILTIN_RESOURCELOCATION = new ResourceLocation("dungeons_libraries", "gear_config");
    public static final CodecJsonDataManager<MeleeGearConfig> GEAR_CONFIGS = new CodecJsonDataManager<MeleeGearConfig>("gearconfig", MeleeGearConfig.CODEC, DungeonsLibraries.LOGGER);

    public static MeleeGearConfig getConfig(ResourceLocation resourceLocation) {
        return GearConfigRegistry.GEAR_CONFIGS.data.getOrDefault(resourceLocation, MeleeGearConfig.DEFAULT);
    }

    public static boolean gearConfigExists(ResourceLocation resourceLocation) {
        return GearConfigRegistry.GEAR_CONFIGS.data.containsKey(resourceLocation);
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener(GEAR_CONFIGS);
        event.addListener((IFutureReloadListener)new GearConfigReload());
    }
}

