/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.entities;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TotemBaseEntity
extends Entity {
    private final EntityPredicate entityTargeting = new EntityPredicate().func_221013_a(8.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();
    protected int lifeTicks = 80;
    protected int deathTicks = 40;
    private float totemDeathAnimationO;
    private float totemDeathAnimation;
    private LivingEntity owner;
    private UUID ownerUUID;

    public TotemBaseEntity(EntityType<?> p_i48580_1_, World p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    public TotemBaseEntity(EntityType<?> p_i48580_1_, World p_i48580_2_, int lifeTicks, int deathTicks) {
        super(p_i48580_1_, p_i48580_2_);
        this.lifeTicks = lifeTicks;
        this.deathTicks = deathTicks;
    }

    protected void func_70088_a() {
    }

    public int getLifeTicks() {
        return this.lifeTicks;
    }

    public int getDeathTicks() {
        return this.deathTicks;
    }

    public void setLifeTicks(int lifeTicks) {
        this.lifeTicks = lifeTicks;
    }

    public boolean isTotemDeath() {
        return this.lifeTicks <= 0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.totemDeathAnimationO = this.totemDeathAnimation;
            this.totemDeathAnimation = this.isTotemDeath() ? MathHelper.func_76131_a((float)(this.totemDeathAnimation + 0.1f), (float)0.0f, (float)1.0f) : MathHelper.func_76131_a((float)(this.totemDeathAnimation - 0.1f), (float)0.0f, (float)1.0f);
        }
        if (this.lifeTicks > 0) {
            --this.lifeTicks;
            List list = this.field_70170_p.func_217357_a(Entity.class, this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
            if (!list.isEmpty()) {
                this.affectTotemPower(list);
            }
        } else if (this.deathTicks > 0) {
            --this.deathTicks;
        } else {
            this.func_70106_y();
        }
    }

    protected abstract void affectTotemPower(List<Entity> var1);

    @OnlyIn(value=Dist.CLIENT)
    public float getTotemDeathAnimationScale(float p_189795_1_) {
        return MathHelper.func_219799_g((float)p_189795_1_, (float)this.totemDeathAnimationO, (float)this.totemDeathAnimation);
    }

    public void setOwner(@Nullable LivingEntity p_190549_1_) {
        this.owner = p_190549_1_;
        this.ownerUUID = p_190549_1_ == null ? null : p_190549_1_.func_110124_au();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void func_70037_a(CompoundNBT pCompound) {
        if (pCompound.func_150297_b("LifeTicks", 99)) {
            this.lifeTicks = pCompound.func_74762_e("LifeTicks");
        }
        if (pCompound.func_150297_b("DeathTicks", 99)) {
            this.deathTicks = pCompound.func_74762_e("DeathTicks");
        }
        if (pCompound.func_186855_b("Owner")) {
            this.ownerUUID = pCompound.func_186857_a("Owner");
        }
    }

    protected void func_213281_b(CompoundNBT pCompound) {
        pCompound.func_74768_a("LifeTicks", this.lifeTicks);
        pCompound.func_74768_a("DeathTicks", this.deathTicks);
        if (this.ownerUUID != null) {
            pCompound.func_186854_a("Owner", this.ownerUUID);
        }
    }
}

