/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.entities;

import com.infamous.dungeons_libraries.capabilities.soulcaster.ISoulCaster;
import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCasterHelper;
import com.infamous.dungeons_libraries.entities.ModEntityTypes;
import com.infamous.dungeons_libraries.event.PlayerSoulEvent;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class SoulOrbEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public int field_70173_aa;
    public int age;
    public int floatTime = 20;
    private int health = 5;
    public float value;
    private PlayerEntity followingPlayer;
    private int followingTime;

    public SoulOrbEntity(PlayerEntity followingPlayer, World level, double x, double y, double z, float value) {
        this((EntityType<? extends SoulOrbEntity>)((EntityType)ModEntityTypes.SOUL_ORB.get()), level);
        this.followingPlayer = followingPlayer;
        this.func_70107_b(x, y, z);
        this.field_70177_z = (float)(this.field_70146_Z.nextDouble() * 360.0);
        this.func_213293_j((this.field_70146_Z.nextDouble() * (double)0.2f - (double)0.1f) * 2.0, this.field_70146_Z.nextDouble() * 0.2 * 2.0, (this.field_70146_Z.nextDouble() * (double)0.2f - (double)0.1f) * 2.0);
        this.value = value;
        this.func_189654_d(true);
    }

    public SoulOrbEntity(EntityType<? extends SoulOrbEntity> p_i50382_1_, World p_i50382_2_) {
        super(p_i50382_1_, p_i50382_2_);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213293_j(0.0, 0.0, 0.0);
        if (this.floatTime > 0) {
            this.func_213293_j(0.0, 0.05, 0.0);
            --this.floatTime;
        }
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        if (this.func_208600_a((ITag)FluidTags.field_206959_a)) {
            this.setUnderwaterMovement();
        } else if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.03, 0.0));
        }
        if (!this.field_70170_p.func_226664_a_(this.func_174813_aQ())) {
            this.func_213282_i(this.func_226277_ct_(), (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.func_226281_cx_());
        }
        double d0 = 8.0;
        if (this.followingPlayer == null || this.followingPlayer.func_175149_v()) {
            this.func_70106_y();
        }
        if (this.followingPlayer != null && this.floatTime == 0) {
            Vector3d vector3d = new Vector3d(this.followingPlayer.func_226277_ct_() - this.func_226277_ct_(), this.followingPlayer.func_226278_cu_() + (double)this.followingPlayer.func_70047_e() / 2.0 - this.func_226278_cu_(), this.followingPlayer.func_226281_cx_() - this.func_226281_cx_());
            double d1 = (double)this.field_70173_aa * 0.0075;
            this.func_213317_d(this.func_213322_ci().func_178787_e(vector3d.func_72432_b().func_186678_a(d1)));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        float f = 0.98f;
        this.func_213317_d(this.func_213322_ci().func_216372_d((double)f, (double)f, (double)f));
        ++this.field_70173_aa;
        ++this.age;
        if (this.age >= 6000) {
            this.func_70106_y();
        }
    }

    private void setUnderwaterMovement() {
        Vector3d vector3d = this.func_213322_ci();
        this.func_213293_j(vector3d.field_72450_a * (double)0.99f, Math.min(vector3d.field_72448_b + (double)5.0E-4f, (double)0.06f), vector3d.field_72449_c * (double)0.99f);
    }

    protected void func_71061_d_() {
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return false;
        }
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        this.func_70018_K();
        this.health = (int)((float)this.health - p_70097_2_);
        if (this.health <= 0) {
            this.func_70106_y();
        }
        return false;
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        p_213281_1_.func_74777_a("Health", (short)this.health);
        p_213281_1_.func_74777_a("Age", (short)this.age);
        p_213281_1_.func_74777_a("Value", (short)this.value);
        p_213281_1_.func_74777_a("FloatTime", (short)this.floatTime);
        p_213281_1_.func_186854_a("FollowingPlayer", this.followingPlayer.func_110124_au());
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        this.health = p_70037_1_.func_74765_d("Health");
        this.age = p_70037_1_.func_74765_d("Age");
        this.value = p_70037_1_.func_74765_d("Value");
        this.floatTime = p_70037_1_.func_74765_d("FloatTime");
        UUID followingPlayerUUID = p_70037_1_.func_186857_a("FollowingPlayer");
        PlayerEntity playerByUUID = this.field_70170_p.func_217371_b(followingPlayerUUID);
        if (playerByUUID != null) {
            this.followingPlayer = playerByUUID;
        }
    }

    public void func_70100_b_(PlayerEntity playerEntity) {
        if (!this.field_70170_p.field_72995_K && this.floatTime == 0) {
            ISoulCaster soulCasterCapability;
            if (MinecraftForge.EVENT_BUS.post((Event)new PlayerSoulEvent.PickupSoul(playerEntity, this))) {
                return;
            }
            if (this.value > 0.0f && (soulCasterCapability = SoulCasterHelper.getSoulCasterCapability((Entity)playerEntity)) != null) {
                SoulCasterHelper.addSouls((LivingEntity)playerEntity, this.value);
            }
            this.func_70106_y();
        }
    }

    public float getValue() {
        return this.value;
    }

    public int getIcon() {
        if (this.value > 10.0f) {
            return 10;
        }
        if (this.value < 1.0f) {
            return 0;
        }
        return (int)this.value - 1;
    }

    public boolean func_70075_an() {
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.health);
        buffer.writeInt(this.age);
        buffer.writeFloat(this.value);
        buffer.func_179252_a(this.followingPlayer.func_110124_au());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.health = additionalData.readInt();
        this.age = additionalData.readInt();
        this.value = additionalData.readFloat();
        PlayerEntity playerByUUID = this.field_70170_p.func_217371_b(additionalData.func_179253_g());
        if (playerByUUID != null) {
            this.followingPlayer = playerByUUID;
        }
    }
}

