/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.data.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.Logger;

public class CodecJsonDataManager<T>
extends JsonReloadListener {
    private static final Gson STANDARD_GSON = new Gson();
    private final Codec<T> codec;
    private final Logger logger;
    private final String folderName;
    public Map<ResourceLocation, T> data = new HashMap<ResourceLocation, T>();
    private Optional<Runnable> syncOnReloadCallback = Optional.empty();

    public CodecJsonDataManager(String folderName, Codec<T> codec, Logger logger) {
        this(folderName, codec, logger, STANDARD_GSON);
    }

    public CodecJsonDataManager(String folderName, Codec<T> codec, Logger logger, Gson gson) {
        super(gson, folderName);
        this.folderName = folderName;
        this.codec = codec;
        this.logger = logger;
    }

    @Nullable
    public T getData(ResourceLocation id) {
        return this.data.get(id);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, IResourceManager resourceManager, IProfiler profiler) {
        this.logger.info("Beginning loading of data for data loader: {}", (Object)this.folderName);
        this.data = this.mapValues(jsons);
        this.logger.info("Data loader for {} loaded {} jsons", (Object)this.folderName, (Object)this.data.size());
        boolean isServer = true;
        try {
            LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        }
        catch (IllegalStateException e) {
            isServer = false;
        }
        catch (NullPointerException e) {
            isServer = false;
        }
        if (isServer) {
            this.syncOnReloadCallback.ifPresent(Runnable::run);
        }
    }

    private Map<ResourceLocation, T> mapValues(Map<ResourceLocation, JsonElement> inputs) {
        HashMap newMap = new HashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : inputs.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(result -> newMap.put(key, result.getFirst())).ifRight(partial -> this.logger.error("Failed to parse data json for {} due to: {}", (Object)key.toString(), (Object)partial.message()));
        }
        return newMap;
    }

    public <PACKET> CodecJsonDataManager<T> subscribeAsSyncable(SimpleChannel channel, Function<Map<ResourceLocation, T>, PACKET> packetFactory) {
        MinecraftForge.EVENT_BUS.addListener(this.getLoginListener(channel, packetFactory));
        this.syncOnReloadCallback = Optional.of(() -> channel.send(PacketDistributor.ALL.noArg(), packetFactory.apply(this.data)));
        return this;
    }

    private <PACKET> Consumer<PlayerEvent.PlayerLoggedInEvent> getLoginListener(SimpleChannel channel, Function<Map<ResourceLocation, T>, PACKET> packetFactory) {
        return event -> {
            PlayerEntity player = event.getPlayer();
            if (player instanceof ServerPlayerEntity) {
                channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), packetFactory.apply(this.data));
            }
        };
    }

    public boolean hasData() {
        return !this.data.isEmpty();
    }
}

