/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class Codecs {
    public static final Codec<EnchantmentData> ENCHANTMENT_DATA_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.fieldOf("enchantment").forGetter(data -> data.field_76302_b.getRegistryName()), (App)Codec.INT.fieldOf("level").forGetter(data -> data.field_76303_c)).apply((Applicative)instance, Codecs::getEnchantmentData));
    public static final Codec<Rarity> ITEM_RARITY_CODEC = Codec.STRING.flatComapMap(Rarity::valueOf, d -> DataResult.success((Object)d.name()));

    private static EnchantmentData getEnchantmentData(ResourceLocation resourceLocation, int level) {
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(resourceLocation);
        return new EnchantmentData(enchantment, level);
    }
}

