/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.commands.arguments;

import com.infamous.dungeons_libraries.mobenchantments.MobEnchantment;
import com.infamous.dungeons_libraries.mobenchantments.MobEnchantmentsRegistry;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class MobEnchantmentArgument
implements ArgumentType<MobEnchantment> {
    private static final Collection<String> EXAMPLES = Arrays.asList("spooky", "effect");
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_EFFECT = new DynamicCommandExceptionType(p_208663_0_ -> new TranslationTextComponent("mobEnchantment.mobEnchantmentNotFound", new Object[]{p_208663_0_}));

    public static MobEnchantmentArgument mobEnchantment() {
        return new MobEnchantmentArgument();
    }

    public static MobEnchantment getMobEnchantment(CommandContext<CommandSource> source, String name) throws CommandSyntaxException {
        return (MobEnchantment)((Object)source.getArgument(name, MobEnchantment.class));
    }

    public MobEnchantment parse(StringReader p_parse_1_) throws CommandSyntaxException {
        ResourceLocation resourcelocation = ResourceLocation.func_195826_a((StringReader)p_parse_1_);
        if (MobEnchantmentsRegistry.MOB_ENCHANTMENTS.containsKey(resourcelocation)) {
            return (MobEnchantment)MobEnchantmentsRegistry.MOB_ENCHANTMENTS.getValue(resourcelocation);
        }
        throw ERROR_UNKNOWN_EFFECT.create((Object)resourcelocation);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_listSuggestions_1_, SuggestionsBuilder p_listSuggestions_2_) {
        return ISuggestionProvider.func_197014_a((Iterable)MobEnchantmentsRegistry.MOB_ENCHANTMENTS.getKeys(), (SuggestionsBuilder)p_listSuggestions_2_);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

