/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.commands;

import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCasterHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SoulsCommand {
    private static final SimpleCommandExceptionType ERROR_ADD_FAILED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.souls.add.failed"));
    private static final SimpleCommandExceptionType ERROR_SET_FAILED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.souls.set.failed"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder mobEnchantCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"souls").requires(commandSource -> commandSource.func_197034_c(2))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(p_198445_0_ -> SoulsCommand.addSouls((CommandSource)p_198445_0_.getSource(), EntityArgument.func_197090_e((CommandContext)p_198445_0_, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)p_198445_0_, (String)"amount"))))))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(p_198445_0_ -> SoulsCommand.setSouls((CommandSource)p_198445_0_.getSource(), EntityArgument.func_197090_e((CommandContext)p_198445_0_, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)p_198445_0_, (String)"amount"))))));
        dispatcher.register(mobEnchantCommand);
    }

    private static int addSouls(CommandSource source, Collection<ServerPlayerEntity> targets, int amount) throws CommandSyntaxException {
        targets.forEach(serverPlayerEntity -> SoulCasterHelper.addSouls((LivingEntity)serverPlayerEntity, amount - 1));
        if (targets.isEmpty()) {
            throw ERROR_ADD_FAILED.create();
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.souls.add.success"), true);
        return targets.size();
    }

    private static int setSouls(CommandSource source, Collection<ServerPlayerEntity> targets, int amount) throws CommandSyntaxException {
        targets.forEach(serverPlayerEntity -> SoulCasterHelper.setSouls((LivingEntity)serverPlayerEntity, amount));
        if (targets.isEmpty()) {
            throw ERROR_SET_FAILED.create();
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.souls.set.success"), true);
        return targets.size();
    }
}

