/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.minionmaster.summon;

import com.infamous.dungeons_libraries.capabilities.minionmaster.IMaster;
import com.infamous.dungeons_libraries.capabilities.minionmaster.IMinion;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionMasterHelper;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_libraries")
public class SummonEvents {
    @SubscribeEvent
    public static void checkSummonedMobIsDead(TickEvent.PlayerTickEvent event) {
        UUID summonedSheep;
        UUID summonedBat;
        UUID summonedLlama;
        UUID summonedWolf;
        UUID summonedGolem;
        Entity entity2;
        PlayerEntity summoner = event.player;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (!summoner.func_70089_S()) {
            return;
        }
        IMaster masterCap = MinionMasterHelper.getMasterCapability((Entity)event.player);
        if (masterCap == null) {
            return;
        }
        if (event.player.field_70170_p.func_201670_d()) {
            return;
        }
        ServerWorld level = (ServerWorld)event.player.field_70170_p;
        if (masterCap.getSummonedGolem() != null && !((entity2 = level.func_217461_a(summonedGolem = masterCap.getSummonedGolem())) instanceof IronGolemEntity)) {
            masterCap.setSummonedGolem(null);
        }
        if (masterCap.getSummonedWolf() != null && !((entity2 = level.func_217461_a(summonedWolf = masterCap.getSummonedWolf())) instanceof WolfEntity)) {
            masterCap.setSummonedWolf(null);
        }
        if (masterCap.getSummonedLlama() != null && !((entity2 = level.func_217461_a(summonedLlama = masterCap.getSummonedLlama())) instanceof LlamaEntity)) {
            masterCap.setSummonedLlama(null);
        }
        if (masterCap.getSummonedBat() != null && !((entity2 = level.func_217461_a(summonedBat = masterCap.getSummonedBat())) instanceof BatEntity)) {
            masterCap.setSummonedBat(null);
        }
        if (masterCap.getSummonedSheep() != null && !((entity2 = level.func_217461_a(summonedSheep = masterCap.getSummonedSheep())) instanceof SheepEntity)) {
            masterCap.setSummonedSheep(null);
        }
        List<UUID> summonedMobs = masterCap.getSummonedMobs();
        List aliveMobs = summonedMobs.stream().map(arg_0 -> ((ServerWorld)level).func_217461_a(arg_0)).filter(entity -> entity != null && entity.func_70089_S()).collect(Collectors.toList());
        masterCap.setSummonedMobs(aliveMobs.stream().map(Entity::func_110124_au).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public static void onSummonableDeath(LivingDeathEvent event) {
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && MinionMasterHelper.isMinionEntity((Entity)event.getEntityLiving())) {
            PlayerEntity summoner;
            LivingEntity livingEntity = event.getEntityLiving();
            ServerWorld level = (ServerWorld)livingEntity.field_70170_p;
            IMinion summonableCap = MinionMasterHelper.getMinionCapability((Entity)livingEntity);
            if (summonableCap == null) {
                return;
            }
            if (summonableCap.getMaster() != null && (summoner = level.func_217371_b(summonableCap.getMaster())) != null) {
                IMaster masterCap = MinionMasterHelper.getMasterCapability((Entity)summoner);
                if (masterCap == null) {
                    return;
                }
                UUID summonableUUID = livingEntity.func_110124_au();
                if (masterCap.getSummonedGolem() == summonableUUID) {
                    masterCap.setSummonedGolem(null);
                }
                if (masterCap.getSummonedWolf() == summonableUUID) {
                    masterCap.setSummonedWolf(null);
                }
                if (masterCap.getSummonedLlama() == summonableUUID) {
                    masterCap.setSummonedLlama(null);
                }
                if (masterCap.getSummonedBat() == summonableUUID) {
                    masterCap.setSummonedBat(null);
                }
                if (masterCap.getSummonedSheep() == summonableUUID) {
                    masterCap.setSummonedSheep(null);
                }
                List<UUID> summonedMobs = masterCap.getSummonedMobs();
                List aliveMobs = summonedMobs.stream().map(arg_0 -> ((ServerWorld)level).func_217461_a(arg_0)).filter(entity -> entity != null && entity.func_70089_S()).collect(Collectors.toList());
                masterCap.setSummonedMobs(aliveMobs.stream().map(Entity::func_110124_au).collect(Collectors.toList()));
            }
        }
    }

    @SubscribeEvent
    public static void cloneSummonerCaps(PlayerEvent.Clone event) {
        IMaster oldSummonerCap = MinionMasterHelper.getMasterCapability((Entity)event.getOriginal());
        IMaster newSummonerCap = MinionMasterHelper.getMasterCapability((Entity)event.getPlayer());
        if (oldSummonerCap != null && newSummonerCap != null) {
            newSummonerCap.copyFrom(oldSummonerCap);
        }
    }

    @SubscribeEvent
    public static void reAddSummonableGoals(EntityJoinWorldEvent event) {
        if (MinionMasterHelper.isMinionEntity(event.getEntity())) {
            IMinion summonableCap = MinionMasterHelper.getMinionCapability(event.getEntity());
            if (summonableCap == null) {
                return;
            }
            if (event.getEntity() instanceof BeeEntity) {
                BeeEntity beeEntity = (BeeEntity)event.getEntity();
                if (summonableCap.getMaster() != null) {
                    beeEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)beeEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator instanceof IMob && !(entityIterator instanceof CreeperEntity)));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSummonedMobAttemptsToAttack(LivingSetAttackTargetEvent event) {
        if (event.getTarget() == null) {
            return;
        }
        if (MinionMasterHelper.isMinionEntity((Entity)event.getEntityLiving())) {
            LivingEntity minionAttacker = event.getEntityLiving();
            IMinion attackerMinionCap = MinionMasterHelper.getMinionCapability((Entity)minionAttacker);
            if (attackerMinionCap == null) {
                return;
            }
            if (attackerMinionCap.getMaster() != null) {
                UUID attackersOwner = attackerMinionCap.getMaster();
                if (MinionMasterHelper.isMinionEntity((Entity)event.getTarget())) {
                    UUID targetsOwner;
                    LivingEntity summonableTarget = event.getTarget();
                    IMinion targetSummonableCap = MinionMasterHelper.getMinionCapability((Entity)summonableTarget);
                    if (targetSummonableCap == null) {
                        return;
                    }
                    if (targetSummonableCap.getMaster() != null && (targetsOwner = targetSummonableCap.getMaster()).equals(attackersOwner)) {
                        SummonEvents.preventAttackForSummonableMob(minionAttacker);
                    }
                }
            }
            if (attackerMinionCap.getMaster() == event.getTarget().func_110124_au()) {
                SummonEvents.preventAttackForSummonableMob(minionAttacker);
            }
        }
    }

    private static void preventAttackForSummonableMob(LivingEntity minionAttacker) {
        if (minionAttacker instanceof IAngerable) {
            ((IAngerable)minionAttacker).func_241356_K__();
        }
        if (minionAttacker instanceof MobEntity) {
            MobEntity mob = (MobEntity)minionAttacker;
            mob.func_70624_b(null);
            mob.func_70604_c(null);
        }
    }
}

