/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.minionmaster;

import com.infamous.dungeons_libraries.capabilities.minionmaster.IMaster;
import com.infamous.dungeons_libraries.capabilities.minionmaster.IMinion;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MasterProvider;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionProvider;
import com.infamous.dungeons_libraries.capabilities.minionmaster.goals.MasterHurtByTargetGoal;
import com.infamous.dungeons_libraries.capabilities.minionmaster.goals.MasterHurtTargetGoal;
import com.infamous.dungeons_libraries.capabilities.minionmaster.goals.MinionFollowOwnerGoal;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraftforge.common.util.LazyOptional;

public class MinionMasterHelper {
    @Nullable
    public static LivingEntity getOwnerForHorse(AbstractHorseEntity horseEntity) {
        try {
            if (horseEntity.func_184780_dh() != null) {
                UUID ownerUniqueId = horseEntity.func_184780_dh();
                return ownerUniqueId == null ? null : horseEntity.field_70170_p.func_217371_b(ownerUniqueId);
            }
            return null;
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public static boolean isMinionEntity(Entity target) {
        return target instanceof IronGolemEntity || target instanceof WolfEntity || target instanceof LlamaEntity || target instanceof BatEntity || target instanceof BeeEntity || target instanceof SheepEntity;
    }

    public static boolean isMinionOf(LivingEntity target, UUID ownerUUID) {
        if (MinionMasterHelper.isMinionEntity((Entity)target)) {
            IMinion targetSummonableCap = MinionMasterHelper.getMinionCapability((Entity)target);
            if (targetSummonableCap == null) {
                return false;
            }
            return targetSummonableCap.getMaster() != null && targetSummonableCap.getMaster() == ownerUUID;
        }
        return false;
    }

    @Nullable
    public static LivingEntity getMaster(LivingEntity minionMob) {
        try {
            IMinion minion = MinionMasterHelper.getMinionCapability((Entity)minionMob);
            if (minion == null) {
                return null;
            }
            if (minion.getMaster() != null) {
                UUID ownerUniqueId = minion.getMaster();
                return ownerUniqueId == null ? null : minionMob.field_70170_p.func_217371_b(ownerUniqueId);
            }
            return null;
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Nullable
    public static IMaster getMasterCapability(Entity entity) {
        LazyOptional lazyCap = entity.getCapability(MasterProvider.MASTER_CAPABILITY);
        if (lazyCap.isPresent()) {
            return (IMaster)lazyCap.orElseThrow(() -> new IllegalStateException("Couldn't get the summoner capability from the Entity!"));
        }
        return null;
    }

    @Nullable
    public static IMinion getMinionCapability(Entity entity) {
        LazyOptional lazyCap = entity.getCapability(MinionProvider.MINION_CAPABILITY);
        if (lazyCap.isPresent()) {
            return (IMinion)lazyCap.orElseThrow(() -> new IllegalStateException("Couldn't get the summonable capability from the Entity!"));
        }
        return null;
    }

    public static void addMinionGoals(Entity entity) {
        IMinion minionCap = MinionMasterHelper.getMinionCapability(entity);
        if (minionCap == null) {
            return;
        }
        if (minionCap.isMinion() && (entity instanceof IronGolemEntity || entity instanceof BeeEntity)) {
            MobEntity mobEntity = (MobEntity)entity;
            mobEntity.field_70714_bg.func_75776_a(2, (Goal)new MinionFollowOwnerGoal(mobEntity, 2.1, 10.0f, 2.0f, false));
            mobEntity.field_70715_bh.func_75776_a(1, (Goal)new MasterHurtByTargetGoal(mobEntity));
            mobEntity.field_70715_bh.func_75776_a(2, (Goal)new MasterHurtTargetGoal(mobEntity));
        }
    }
}

