/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.builtinenchants;

import com.infamous.dungeons_libraries.capabilities.builtinenchants.IBuiltInEnchantments;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;

public class BuiltInEnchantmentsStorage
implements Capability.IStorage<IBuiltInEnchantments> {
    public static final String ENCHANTS_KEY = "BuiltInEnchantments";
    public static final String SOURCE_KEY = "source";
    public static final String ENCHANTMENT_DATA_KEY = "data";

    public INBT writeNBT(Capability<IBuiltInEnchantments> capability, IBuiltInEnchantments instance, Direction side) {
        CompoundNBT tag = new CompoundNBT();
        ListNBT listnbt = new ListNBT();
        instance.getAllBuiltInEnchantmentDatasPerSource().forEach((resourceLocation, enchantmentDatas) -> {
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74778_a(SOURCE_KEY, String.valueOf(resourceLocation));
            ListNBT enchantmentListnbt = new ListNBT();
            enchantmentDatas.forEach(enchantmentData -> {
                CompoundNBT enchantmentDataNBT = new CompoundNBT();
                enchantmentDataNBT.func_74778_a("id", String.valueOf(enchantmentData.field_76302_b.getRegistryName()));
                enchantmentDataNBT.func_74777_a("lvl", (short)enchantmentData.field_76303_c);
                enchantmentListnbt.add((Object)enchantmentDataNBT);
            });
            compoundnbt.func_218657_a(ENCHANTMENT_DATA_KEY, (INBT)enchantmentListnbt);
            listnbt.add((Object)compoundnbt);
        });
        tag.func_218657_a(ENCHANTS_KEY, (INBT)listnbt);
        return tag;
    }

    public void readNBT(Capability<IBuiltInEnchantments> capability, IBuiltInEnchantments instance, Direction side, INBT nbt) {
        CompoundNBT tag = (CompoundNBT)nbt;
        ListNBT listNBT = tag.func_150295_c(ENCHANTS_KEY, 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundNBT compoundnbt = listNBT.func_150305_b(i);
            ResourceLocation resourcelocation = ResourceLocation.func_208304_a((String)compoundnbt.func_74779_i(SOURCE_KEY));
            ListNBT enchantmentListnbt = new ListNBT();
            Map enchantmentIntegerMap = EnchantmentHelper.func_226652_a_((ListNBT)compoundnbt.func_150295_c(ENCHANTMENT_DATA_KEY, 10));
            List<EnchantmentData> enchantmentDataList = enchantmentIntegerMap.entrySet().stream().map(entry -> new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue())).collect(Collectors.toList());
            instance.setBuiltInEnchantments(resourcelocation, enchantmentDataList);
        }
    }
}

