/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.builtinenchants;

import com.google.common.collect.Lists;
import com.infamous.dungeons_libraries.capabilities.builtinenchants.IBuiltInEnchantments;
import com.infamous.dungeons_libraries.items.gearconfig.GearConfigRegistry;
import com.infamous.dungeons_libraries.items.gearconfig.MeleeGear;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class BuiltInEnchantments
implements IBuiltInEnchantments {
    private Map<ResourceLocation, List<EnchantmentData>> enchantments = new HashMap<ResourceLocation, List<EnchantmentData>>();

    public BuiltInEnchantments() {
    }

    public BuiltInEnchantments(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof MeleeGear) {
            MeleeGear item = (MeleeGear)itemStack.func_77973_b();
            this.enchantments.put(GearConfigRegistry.GEAR_CONFIG_BUILTIN_RESOURCELOCATION, new ArrayList<EnchantmentData>(item.getGearConfig().getBuiltInEnchantments()));
        }
    }

    @Override
    public boolean addBuiltInEnchantment(ResourceLocation source, EnchantmentData enchantmentData) {
        this.enchantments.computeIfAbsent(source, resourceLocation -> this.enchantments.put((ResourceLocation)resourceLocation, new ArrayList()));
        this.enchantments.get(source).add(enchantmentData);
        return true;
    }

    @Override
    public boolean removeBuiltInEnchantment(ResourceLocation source, Enchantment enchantment) {
        if (!this.enchantments.containsKey(source)) {
            return false;
        }
        this.enchantments.put(source, this.enchantments.get(source).stream().filter(enchantmentData -> enchantmentData.field_76302_b != enchantment).collect(Collectors.toList()));
        return true;
    }

    @Override
    public boolean setBuiltInEnchantments(ResourceLocation source, List<EnchantmentData> enchantmentData) {
        this.enchantments.put(source, new ArrayList<EnchantmentData>(enchantmentData));
        return true;
    }

    @Override
    public boolean clearAllBuiltInEnchantments(ResourceLocation source) {
        this.enchantments.remove(source);
        return true;
    }

    @Override
    public List<EnchantmentData> getBuiltInEnchantments(ResourceLocation source) {
        List<EnchantmentData> enchantmentData = this.enchantments.get(source);
        if (enchantmentData == null) {
            return Lists.newArrayList();
        }
        return enchantmentData;
    }

    @Override
    public List<EnchantmentData> getAllBuiltInEnchantmentDatas() {
        return this.enchantments.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public Map<ResourceLocation, List<EnchantmentData>> getAllBuiltInEnchantmentDatasPerSource() {
        return this.enchantments;
    }

    @Override
    public boolean hasBuiltInEnchantment(ResourceLocation source) {
        return !this.getBuiltInEnchantments(source).isEmpty();
    }

    @Override
    public boolean hasBuiltInEnchantment() {
        return !this.enchantments.isEmpty();
    }

    @Override
    public boolean hasBuiltInEnchantment(Enchantment enchantment) {
        return this.getAllBuiltInEnchantmentDatas().stream().anyMatch(enchantmentData -> enchantmentData.field_76302_b.equals(enchantment));
    }

    @Override
    public int getBuiltInItemEnchantmentLevel(Enchantment enchantment) {
        return this.getAllBuiltInEnchantmentDatas().stream().filter(enchantmentData -> enchantmentData.field_76302_b.equals(enchantment)).map(enchantmentData -> enchantmentData.field_76303_c).max(Comparator.naturalOrder()).orElse(0);
    }
}

