/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities;

import com.infamous.dungeons_libraries.capabilities.builtinenchants.BuiltInEnchantmentsProvider;
import com.infamous.dungeons_libraries.capabilities.enchantable.EnchantableHelper;
import com.infamous.dungeons_libraries.capabilities.enchantable.EnchantableProvider;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MasterProvider;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionMasterHelper;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionProvider;
import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCasterHelper;
import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCasterProvider;
import com.infamous.dungeons_libraries.network.NetworkHandler;
import com.infamous.dungeons_libraries.network.UpdateSoulsMessage;
import java.util.Arrays;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="dungeons_libraries")
public class CapabilityEvents {
    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (MinionMasterHelper.isMinionEntity((Entity)event.getObject())) {
            event.addCapability(new ResourceLocation("dungeons_libraries", "summonable"), (ICapabilityProvider)new MinionProvider());
        }
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("dungeons_libraries", "summoner"), (ICapabilityProvider)new MasterProvider());
            event.addCapability(new ResourceLocation("dungeons_libraries", "soul_caster"), (ICapabilityProvider)new SoulCasterProvider());
        }
        if (EnchantableHelper.isEnchantableEntity((Entity)event.getObject())) {
            event.addCapability(new ResourceLocation("dungeons_libraries", "enchantable"), (ICapabilityProvider)new EnchantableProvider());
        }
    }

    @SubscribeEvent
    public static void onAttachItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        event.addCapability(new ResourceLocation("dungeons_libraries", "built_in_enchantments"), (ICapabilityProvider)new BuiltInEnchantmentsProvider((ItemStack)event.getObject()));
    }

    private static boolean canBeEnchanted(ItemStack itemStack) {
        return Arrays.stream(EnchantmentType.values()).anyMatch(enchantmentType -> enchantmentType.func_77557_a(itemStack.func_77973_b()));
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getEntity()), (Object)new UpdateSoulsMessage(SoulCasterHelper.getSoulCasterCapability(event.getEntity()).getSouls()));
        }
    }
}

