/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.util;

import fuzs.puzzleslib.util.PuzzlesUtil;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModEntryList
extends ArrayList<String> {
    public void add(IForgeRegistryEntry<?> ... elements) {
        Stream.of(elements).forEach(this::add);
    }

    public void add(IForgeRegistryEntry<?> element) {
        this.add(element.getRegistryName());
    }

    public void add(String ... elements) {
        if (elements.length % 2 != 0) {
            throw new IllegalStateException("Odd number of elements, needs pairs of two for namespace and path");
        }
        for (int i = 0; i < elements.length; ++i) {
            this.add(new ResourceLocation(elements[i], elements[++i]));
        }
    }

    public void add(ResourceLocation ... elements) {
        Stream.of(elements).forEach(this::add);
    }

    public void add(ResourceLocation element) {
        if (FMLLoader.getLoadingModList() == null || FMLLoader.getLoadingModList().getModFileById(element.func_110624_b()) != null) {
            this.add(element.toString());
        }
    }

    @Override
    @Deprecated
    public boolean add(String s) {
        return super.add(s);
    }

    public static ModEntryList of(IForgeRegistryEntry<?> ... elements) {
        return PuzzlesUtil.make(new ModEntryList(), list -> list.add(elements));
    }

    public static ModEntryList of(String ... elements) {
        return PuzzlesUtil.make(new ModEntryList(), list -> list.add(elements));
    }

    public static ModEntryList of(ResourceLocation ... elements) {
        return PuzzlesUtil.make(new ModEntryList(), list -> list.add(elements));
    }
}

