/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.registry;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;

public enum FuelManager {
    INSTANCE;

    private final Object2IntOpenHashMap<Item> fuelValues = new Object2IntOpenHashMap();

    private FuelManager() {
        MinecraftForge.EVENT_BUS.addListener(this::onFurnaceFuelBurnTime);
    }

    public void addItem(Item item, int fuelPower) {
        if (fuelPower > 0 && item != null) {
            this.fuelValues.put((Object)item, fuelPower);
        }
    }

    public void addBlock(Block block, int fuelPower) {
        this.addItem(block.func_199767_j(), fuelPower);
    }

    public void addWoodenBlock(Block block) {
        this.addBlock(block, block instanceof SlabBlock ? 150 : 300);
    }

    private void onFurnaceFuelBurnTime(FurnaceFuelBurnTimeEvent evt) {
        Item item = evt.getItemStack().func_77973_b();
        if (this.fuelValues.containsKey((Object)item)) {
            evt.setBurnTime(this.fuelValues.getInt((Object)item));
        }
    }
}

