/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.element;

import java.util.List;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public abstract class EventListener {
    protected abstract List<EventStorage<? extends Event>> getEventListeners();

    protected final <T extends Event> void addListener(Consumer<T> consumer) {
        this.addListener(consumer, EventPriority.NORMAL);
    }

    protected final <T extends Event> void addListener(Consumer<T> consumer, boolean receiveCancelled) {
        this.addListener(consumer, EventPriority.NORMAL, receiveCancelled);
    }

    protected final <T extends Event> void addListener(Consumer<T> consumer, EventPriority priority) {
        this.addListener(consumer, priority, false);
    }

    protected final <T extends Event> void addListener(Consumer<T> consumer, EventPriority priority, boolean receiveCancelled) {
        this.getEventListeners().add(new EventStorage(consumer, priority, receiveCancelled));
    }

    protected static class EventStorage<T extends Event> {
        private final Consumer<T> event;
        private final EventPriority priority;
        private final boolean receiveCancelled;
        private boolean active;

        private EventStorage(Consumer<T> consumer, EventPriority priority, boolean receiveCancelled) {
            this.event = consumer;
            this.priority = priority;
            this.receiveCancelled = receiveCancelled;
        }

        protected void register() {
            if (this.isActive(true)) {
                MinecraftForge.EVENT_BUS.addListener(this.priority, this.receiveCancelled, this.event);
            }
        }

        protected void unregister() {
            if (this.isActive(false)) {
                MinecraftForge.EVENT_BUS.unregister(this.event);
            }
        }

        private boolean isActive(boolean newState) {
            if (this.active != newState) {
                this.active = newState;
                return true;
            }
            return false;
        }
    }
}

