/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.element;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.PuzzlesLib;
import fuzs.puzzleslib.config.ConfigManager;
import fuzs.puzzleslib.element.AbstractElement;
import fuzs.puzzleslib.element.side.IClientElement;
import fuzs.puzzleslib.element.side.ICommonElement;
import fuzs.puzzleslib.element.side.IServerElement;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ElementRegistry {
    private static final Map<ResourceLocation, AbstractElement> LOADED_ELEMENTS = Maps.newConcurrentMap();
    private static final Map<ResourceLocation, AbstractElement> REGISTERED_ELEMENTS = Maps.newConcurrentMap();
    private final String modId;

    public ElementRegistry(String modId) {
        this.modId = modId;
    }

    public <T extends AbstractElement> AbstractElement register(String elementName, Supplier<T> supplier) {
        return this.register(elementName, supplier, FMLEnvironment.dist);
    }

    public <T extends AbstractElement> AbstractElement register(String elementName, Supplier<T> supplier, Dist dist) {
        ResourceLocation elementLocation = new ResourceLocation(this.modId, elementName);
        if (dist == FMLEnvironment.dist) {
            AbstractElement element = (AbstractElement)supplier.get();
            assert (element instanceof ICommonElement || FMLEnvironment.dist.isClient() || element instanceof IServerElement) : "Unable to register element: Trying to register client element for server side";
            assert (element instanceof ICommonElement || FMLEnvironment.dist.isDedicatedServer() || element instanceof IClientElement) : "Unable to register element: Trying to register server element for client side";
            PuzzlesLib.LOGGER.info("Registering element {}", (Object)elementLocation);
            REGISTERED_ELEMENTS.put(elementLocation, element);
            return element;
        }
        return AbstractElement.fake(elementLocation);
    }

    public static Optional<AbstractElement> get(String namespace, String key) {
        return ElementRegistry.get(new ResourceLocation(namespace, key));
    }

    public static Optional<AbstractElement> get(ResourceLocation name) {
        return Optional.ofNullable(LOADED_ELEMENTS.get(name));
    }

    public static Collection<AbstractElement> getAllElements(String namespace) {
        return (Collection)LOADED_ELEMENTS.entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).func_110624_b().equals(namespace)).map(Map.Entry::getValue).collect(ImmutableSet.toImmutableSet());
    }

    public static String joinElementNames(Collection<AbstractElement> elements) {
        return elements.stream().map(AbstractElement::getRegistryName).map(ResourceLocation::toString).collect(Collectors.joining(", "));
    }

    public static <T> Optional<T> getConfigValue(String namespace, String key, String ... path) {
        return ElementRegistry.getConfigValue(new ResourceLocation(namespace, key), new String[0]);
    }

    public static <T> Optional<T> getConfigValue(ResourceLocation name, String ... path) {
        Optional<AbstractElement> element = ElementRegistry.get(name);
        if (element.isPresent()) {
            return ElementRegistry.getConfigValue(element.get(), path);
        }
        PuzzlesLib.LOGGER.error("Unable to get config value: Invalid element name");
        return Optional.empty();
    }

    public static <T> Optional<T> getConfigValue(AbstractElement element, String ... path) {
        return element.getValue(path);
    }

    public static void setup(boolean shouldCreateConfig, boolean loadConfigEarly, String ... configSubPath) {
        ModContainer activeContainer = ModLoadingContext.get().getActiveContainer();
        String activeNamespace = activeContainer.getNamespace();
        for (Map.Entry<ResourceLocation, AbstractElement> entry : REGISTERED_ELEMENTS.entrySet()) {
            ResourceLocation elementName = entry.getKey();
            if (!elementName.func_110624_b().equals(activeNamespace)) continue;
            AbstractElement element = entry.getValue();
            LOADED_ELEMENTS.put(elementName, element.setRegistryName(elementName));
        }
        Collection<AbstractElement> activeElements = ElementRegistry.getAllElements(activeNamespace);
        if (!activeElements.isEmpty()) {
            PuzzlesLib.LOGGER.info("Setting up mod {} with elements {}", (Object)activeNamespace, (Object)ElementRegistry.joinElementNames(activeElements));
        }
        if (shouldCreateConfig) {
            ElementRegistry.createConfig(activeElements, loadConfigEarly, activeContainer, configSubPath);
        }
        activeElements.forEach(AbstractElement::setup);
    }

    private static void createConfig(Collection<AbstractElement> activeElements, boolean loadConfigEarly, ModContainer activeContainer, String[] configSubPath) {
        AbstractElement generalElement = AbstractElement.fake(new ResourceLocation(activeContainer.getNamespace(), "general"));
        if (ConfigManager.load(generalElement, activeElements, loadConfigEarly, activeContainer, configSubPath)) {
            LOADED_ELEMENTS.put(generalElement.getRegistryName(), generalElement);
        }
    }

    public static void load(ParallelDispatchEvent evt, ModConfig.Type syncType) {
        Collection<AbstractElement> elements = LOADED_ELEMENTS.values();
        if (!elements.isEmpty()) {
            PuzzlesLib.LOGGER.info("Loading {} element{} during {} setup...", (Object)elements.size(), (Object)(elements.size() == 1 ? "" : "s"), (Object)syncType.extension());
        }
        ConfigManager.syncOptions(elements, syncType, false);
        elements.forEach(element -> element.load(evt));
    }
}

