/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.capability.CapabilityController;
import fuzs.puzzleslib.core.EnvTypeExecutor;
import fuzs.puzzleslib.element.AbstractElement;
import fuzs.puzzleslib.element.ElementRegistry;
import fuzs.puzzleslib.network.NetworkHandler;
import fuzs.puzzleslib.proxy.ClientProxy;
import fuzs.puzzleslib.proxy.IProxy;
import fuzs.puzzleslib.proxy.ServerProxy;
import fuzs.puzzleslib.recipe.ElementConfigCondition;
import fuzs.puzzleslib.registry.FuelManager;
import fuzs.puzzleslib.registry.v2.RegistryManager;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="puzzleslib")
public class PuzzlesLib {
    public static final String MODID = "puzzleslib";
    public static final String NAME = "Puzzles Lib";
    public static final Logger LOGGER = LogManager.getLogger((String)"Puzzles Lib");
    public static final IProxy PROXY = (IProxy)EnvTypeExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
    @Deprecated
    private static final Map<String, ElementRegistry> ELEMENT_REGISTRIES = Maps.newHashMap();

    public PuzzlesLib() {
        this.addListeners(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private void addListeners(IEventBus bus) {
        bus.addListener(evt -> evt.enqueueWork(() -> this.onCommonSetup((FMLCommonSetupEvent)evt)));
        bus.addListener(evt -> evt.enqueueWork(() -> this.onClientSetup((FMLClientSetupEvent)evt)));
        bus.addListener(evt -> evt.enqueueWork(() -> this.onDedicatedServerSetup((FMLDedicatedServerSetupEvent)evt)));
        bus.register((Object)PuzzlesLib.getRegistryManager());
    }

    private void onCommonSetup(FMLCommonSetupEvent evt) {
        ElementRegistry.load((ParallelDispatchEvent)evt, ModConfig.Type.COMMON);
    }

    private void onClientSetup(FMLClientSetupEvent evt) {
        ElementRegistry.load((ParallelDispatchEvent)evt, ModConfig.Type.CLIENT);
    }

    private void onDedicatedServerSetup(FMLDedicatedServerSetupEvent evt) {
        ElementRegistry.load((ParallelDispatchEvent)evt, ModConfig.Type.SERVER);
    }

    public static void setSideOnly() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (remote, isServer) -> true));
    }

    @Deprecated
    public static void setSideSideOnly() {
        PuzzlesLib.setSideOnly();
    }

    public static void loadRecipeCondition() {
        ElementConfigCondition.loadRecipeCondition();
    }

    @Deprecated
    public static void loadConfigCondition() {
        PuzzlesLib.loadRecipeCondition();
    }

    @Deprecated
    public static IProxy getProxy() {
        return PROXY;
    }

    public static RegistryManager getRegistryManagerV2() {
        return RegistryManager.INSTANCE;
    }

    @Deprecated
    public static fuzs.puzzleslib.registry.RegistryManager getRegistryManager() {
        return fuzs.puzzleslib.registry.RegistryManager.getInstance();
    }

    public static FuelManager getFuelManager() {
        return FuelManager.INSTANCE;
    }

    public static fuzs.puzzleslib.network.v2.NetworkHandler getNetworkHandlerV2() {
        return fuzs.puzzleslib.network.v2.NetworkHandler.INSTANCE;
    }

    @Deprecated
    public static NetworkHandler getNetworkHandler() {
        return NetworkHandler.getInstance();
    }

    public static CapabilityController getCapabilityController() {
        return CapabilityController.getInstance();
    }

    @Deprecated
    public static <T extends AbstractElement> AbstractElement register(String modId, String elementName, Supplier<T> supplier) {
        return ELEMENT_REGISTRIES.computeIfAbsent(modId, ElementRegistry::new).register(elementName, supplier);
    }

    @Deprecated
    public static <T extends AbstractElement> AbstractElement register(String modId, String elementName, Supplier<T> supplier, Dist dist) {
        return ELEMENT_REGISTRIES.computeIfAbsent(modId, ElementRegistry::new).register(elementName, supplier, dist);
    }

    public static ElementRegistry create(String modId) {
        return new ElementRegistry(modId);
    }

    public static void setup(boolean shouldCreateConfig, String ... configSubPath) {
        ElementRegistry.setup(shouldCreateConfig, false, configSubPath);
    }

    public static void setup(boolean shouldCreateConfig, boolean loadConfigEarly, String ... configSubPath) {
        ElementRegistry.setup(shouldCreateConfig, loadConfigEarly, configSubPath);
    }
}

