/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.colytra.server;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ColytraServerConfig {
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;
    private static final String CONFIG_PREFIX = "gui.colytra.config.";
    public static PermissionMode permissionMode;
    public static List<Item> permissionList;
    public static ColytraMode colytraMode;
    public static int energyUsage;

    public static void bake() {
        permissionMode = (PermissionMode)((Object)ColytraServerConfig.SERVER.permissionMode.get());
        colytraMode = (ColytraMode)((Object)ColytraServerConfig.SERVER.colytraMode.get());
        energyUsage = (Integer)ColytraServerConfig.SERVER.energyUsage.get();
        List configItems = (List)ColytraServerConfig.SERVER.permissionList.get();
        ArrayList<Item> items = new ArrayList<Item>();
        configItems.forEach(id -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
            if (item != null) {
                items.add(item);
            }
        });
        permissionList = items;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static enum ColytraMode {
        NORMAL,
        UNISON,
        PERFECT;

    }

    public static enum PermissionMode {
        BLACKLIST,
        WHITELIST;

    }

    public static class Server {
        public final ForgeConfigSpec.EnumValue<PermissionMode> permissionMode;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> permissionList;
        public final ForgeConfigSpec.EnumValue<ColytraMode> colytraMode;
        public final ForgeConfigSpec.IntValue energyUsage;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("server");
            this.permissionMode = builder.comment("Sets whether the permission list is a blacklist or whitelist").translation("gui.colytra.config.permissionMode").defineEnum("permissionMode", (Enum)PermissionMode.BLACKLIST);
            this.permissionList = builder.comment("List of items by registry name to be blacklisted/whitelisted based on Permission Mode").translation("gui.colytra.config.permissionList").defineList("permissionList", new ArrayList(), s -> s instanceof String);
            this.colytraMode = builder.comment("Sets how the elytra chestplates will behave\nNORMAL: Elytras will exist separately from the chestplate, able to be separated later\nUNISON: Elytras will fuse completely with the chestplate, unable to be separated\nPERFECT: Elytras will fuse completely with the chestplate and flying will not use durability").translation("gui.colytra.config.colytraMode").defineEnum("colytraMode", (Enum)ColytraMode.NORMAL);
            this.energyUsage = builder.comment("How much energy per second elytra flight uses if Unison mode is active and the chestplate uses energy").translation("gui.colytra.config.energyUsage").defineInRange("energyUsage", 1000, 0, Integer.MAX_VALUE);
        }
    }
}

