/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.colytra.common.crafting;

import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import top.theillusivec4.colytra.common.ElytraNBT;
import top.theillusivec4.colytra.server.ColytraServerConfig;

public class ElytraDetachmentRecipe
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<ElytraDetachmentRecipe> CRAFTING_DETACH_ELYTRA = new SpecialRecipeSerializer(ElytraDetachmentRecipe::new);

    public ElytraDetachmentRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World worldIn) {
        if (ColytraServerConfig.colytraMode != ColytraServerConfig.ColytraMode.NORMAL) {
            return false;
        }
        ItemStack itemstack = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack currentStack = inv.func_70301_a(i);
            if (currentStack.func_190926_b()) continue;
            if (!itemstack.func_190926_b() || !ElytraNBT.hasUpgrade(currentStack)) {
                return false;
            }
            itemstack = currentStack;
        }
        return !itemstack.func_190926_b();
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        ItemStack itemstack = ItemStack.field_190927_a;
        for (int k = 0; k < inv.func_70302_i_(); ++k) {
            ItemStack currentStack = inv.func_70301_a(k);
            if (currentStack.func_190926_b()) continue;
            if (!itemstack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            itemstack = ElytraNBT.getElytra(currentStack);
        }
        if (!itemstack.func_190926_b()) {
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack currentStack = inv.func_70301_a(i);
            if (currentStack.func_190926_b() || !ElytraNBT.hasUpgrade(currentStack)) continue;
            currentStack.func_196083_e("colytra:ElytraUpgrade");
            nonnulllist.set(i, (Object)currentStack.func_77946_l());
            break;
        }
        return nonnulllist;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return CRAFTING_DETACH_ELYTRA;
    }
}

