/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.colytra.common.crafting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import top.theillusivec4.colytra.common.ElytraNBT;
import top.theillusivec4.colytra.server.ColytraServerConfig;

public class ElytraAttachmentRecipe
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<ElytraAttachmentRecipe> CRAFTING_ATTACH_ELYTRA = new SpecialRecipeSerializer(ElytraAttachmentRecipe::new);

    public ElytraAttachmentRecipe(ResourceLocation id) {
        super(id);
    }

    private static void mergeEnchantments(ItemStack source, ItemStack destination) {
        Map mapSource = EnchantmentHelper.func_82781_a((ItemStack)source);
        Map mapDestination = EnchantmentHelper.func_82781_a((ItemStack)destination);
        for (Enchantment enchantment : mapSource.keySet()) {
            int srcLevel;
            if (enchantment == null || !enchantment.func_92089_a(destination)) continue;
            int destLevel = mapDestination.getOrDefault(enchantment, 0);
            srcLevel = destLevel == (srcLevel = ((Integer)mapSource.get(enchantment)).intValue()) ? srcLevel + 1 : Math.max(srcLevel, destLevel);
            for (Enchantment destEnch : mapDestination.keySet()) {
                if (enchantment == destEnch || destEnch.func_191560_c(enchantment)) continue;
                return;
            }
            if (srcLevel > enchantment.func_77325_b()) {
                srcLevel = enchantment.func_77325_b();
            }
            mapDestination.put(enchantment, srcLevel);
        }
        EnchantmentHelper.func_82782_a((Map)mapDestination, (ItemStack)destination);
        EnchantmentHelper.func_82782_a(new HashMap(), (ItemStack)source);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World worldIn) {
        ItemStack itemstack = ItemStack.field_190927_a;
        ItemStack elytra = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack currentStack = inv.func_70301_a(i);
            if (currentStack.func_190926_b()) continue;
            if (ElytraAttachmentRecipe.isValid(currentStack)) {
                if (!itemstack.func_190926_b() || ElytraNBT.hasUpgrade(currentStack)) {
                    return false;
                }
                itemstack = currentStack;
                continue;
            }
            if (!elytra.func_190926_b() || !(currentStack.func_77973_b() instanceof ElytraItem)) {
                return false;
            }
            elytra = currentStack;
        }
        return !itemstack.func_190926_b() && !elytra.func_190926_b();
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        ItemStack itemstack = ItemStack.field_190927_a;
        ItemStack elytra = ItemStack.field_190927_a;
        for (int k = 0; k < inv.func_70302_i_(); ++k) {
            ItemStack currentStack = inv.func_70301_a(k);
            if (currentStack.func_190926_b()) continue;
            if (ElytraAttachmentRecipe.isValid(currentStack)) {
                if (!itemstack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                itemstack = currentStack.func_77946_l();
                itemstack.func_190920_e(1);
                continue;
            }
            if (!(currentStack.func_77973_b() instanceof ElytraItem)) {
                return ItemStack.field_190927_a;
            }
            elytra = currentStack.func_77946_l();
        }
        if (!itemstack.func_190926_b() && !elytra.func_190926_b()) {
            if (ColytraServerConfig.colytraMode != ColytraServerConfig.ColytraMode.NORMAL) {
                ElytraAttachmentRecipe.mergeEnchantments(elytra, itemstack);
                itemstack.func_82841_c(elytra.func_82838_A() + itemstack.func_82838_A());
                ITextComponent name = elytra.func_200301_q();
                boolean hasCustomName = elytra.func_82837_s();
                elytra = new ItemStack((IItemProvider)Items.field_185160_cR);
                if (hasCustomName) {
                    elytra.func_200302_a(name);
                }
            }
            itemstack.func_196082_o().func_218657_a("colytra:ElytraUpgrade", (INBT)elytra.func_77955_b(new CompoundNBT()));
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return CRAFTING_ATTACH_ELYTRA;
    }

    private static boolean isValid(ItemStack stack) {
        ColytraServerConfig.PermissionMode permissionMode = ColytraServerConfig.permissionMode;
        List<Item> permissionList = ColytraServerConfig.permissionList;
        boolean isBlacklist = permissionMode == ColytraServerConfig.PermissionMode.BLACKLIST;
        return isBlacklist != permissionList.contains(stack.func_77973_b()) && MobEntity.func_184640_d((ItemStack)stack) == EquipmentSlotType.CHEST && !(stack.func_77973_b() instanceof ElytraItem);
    }
}

