/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.colytra.common;

import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import top.theillusivec4.caelus.api.CaelusApi;
import top.theillusivec4.colytra.common.ElytraNBT;
import top.theillusivec4.colytra.server.ColytraServerConfig;

public class CommonEventHandler {
    public static final AttributeModifier FLIGHT_MODIFIER = new AttributeModifier(UUID.fromString("668bdbee-32b6-4c4b-bf6a-5a30f4d02e37"), "Flight modifier", 1.0, AttributeModifier.Operation.ADDITION);

    private static void updateColytra(ItemStack chestStack, PlayerEntity player) {
        ItemStack elytraStack = ElytraNBT.getElytra(chestStack);
        Integer ticksFlying = (Integer)ObfuscationReflectionHelper.getPrivateValue(LivingEntity.class, (Object)player, (String)"field_184629_bo");
        if (ticksFlying == null || (ticksFlying + 1) % 20 != 0) {
            return;
        }
        ElytraNBT.damageElytra((LivingEntity)player, chestStack, elytraStack, 1);
    }

    private static void handleColytraMending(ItemStack chestStack, PlayerXpEvent.PickupXp evt, PlayerEntity player) {
        ItemStack elytraStack = ElytraNBT.getElytra(chestStack);
        if (elytraStack.func_190926_b() || elytraStack.func_77952_i() <= 0 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)elytraStack) <= 0) {
            return;
        }
        ExperienceOrbEntity xpOrb = evt.getOrb();
        if (xpOrb.field_70532_c == 0 && player.field_71090_bL == 0) {
            int i = Math.min(CommonEventHandler.xpToDurability(xpOrb.field_70530_e), elytraStack.func_77952_i());
            if (i <= 0) {
                return;
            }
            evt.setCanceled(true);
            player.field_71090_bL = 2;
            player.func_71001_a((Entity)xpOrb, 1);
            xpOrb.field_70530_e -= CommonEventHandler.durabilityToXp(i);
            elytraStack.func_196085_b(elytraStack.func_77952_i() - i);
            ElytraNBT.setElytra(chestStack, elytraStack);
            if (xpOrb.field_70530_e > 0) {
                player.func_195068_e(xpOrb.field_70530_e);
            }
            xpOrb.func_70106_y();
        }
    }

    private static int durabilityToXp(int durability) {
        return durability / 2;
    }

    private static int xpToDurability(int xp) {
        return xp * 2;
    }

    private static void handleColytraRepair(ItemStack chestStack, AnvilUpdateEvent evt) {
        ItemStack stack = ElytraNBT.getElytra(chestStack);
        if (stack.func_190926_b()) {
            return;
        }
        ItemStack right = evt.getRight();
        int toRepair = stack.func_77952_i();
        if (right.func_77973_b() != Items.field_204840_eX || toRepair == 0) {
            return;
        }
        int membraneToUse = 0;
        while (toRepair > 0) {
            toRepair -= 108;
            ++membraneToUse;
        }
        membraneToUse = Math.min(membraneToUse, right.func_190916_E());
        int newDamage = Math.max(stack.func_77952_i() - membraneToUse * 108, 0);
        ItemStack output = chestStack.func_77946_l();
        ItemStack outputElytra = stack.func_77946_l();
        outputElytra.func_196085_b(newDamage);
        outputElytra.func_82841_c(stack.func_82838_A() * 2 + 1);
        ElytraNBT.setElytra(output, outputElytra);
        int xpCost = membraneToUse + chestStack.func_82838_A() + right.func_82838_A();
        String name = evt.getName();
        if (name != null && !name.isEmpty() && !name.equals(chestStack.func_200301_q().getString())) {
            output.func_200302_a((ITextComponent)new StringTextComponent(name));
            ++xpCost;
        }
        evt.setMaterialCost(membraneToUse);
        evt.setCost(xpCost);
        evt.setOutput(output);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.side != LogicalSide.SERVER || evt.phase != TickEvent.Phase.END) {
            return;
        }
        PlayerEntity player = evt.player;
        ItemStack stack = player.func_184582_a(EquipmentSlotType.CHEST);
        ModifiableAttributeInstance attributeInstance = player.func_110148_a((Attribute)CaelusApi.ELYTRA_FLIGHT.get());
        if (attributeInstance != null) {
            attributeInstance.func_111124_b(FLIGHT_MODIFIER);
            if (ElytraNBT.isUseable(stack, ElytraNBT.getElytra(stack))) {
                attributeInstance.func_233767_b_(FLIGHT_MODIFIER);
                if (ColytraServerConfig.colytraMode != ColytraServerConfig.ColytraMode.PERFECT) {
                    CommonEventHandler.updateColytra(stack, player);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerXPPickUp(PlayerXpEvent.PickupXp evt) {
        if (ColytraServerConfig.colytraMode != ColytraServerConfig.ColytraMode.NORMAL) {
            return;
        }
        PlayerEntity player = evt.getPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack stack = player.func_184582_a(EquipmentSlotType.CHEST);
        CommonEventHandler.handleColytraMending(stack, evt, player);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onColytraAnvil(AnvilUpdateEvent evt) {
        if (ColytraServerConfig.colytraMode != ColytraServerConfig.ColytraMode.NORMAL) {
            return;
        }
        ItemStack left = evt.getLeft();
        CommonEventHandler.handleColytraRepair(left, evt);
    }
}

