/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class PureDaisyProvider
extends RecipeProvider {
    public PureDaisyProvider(DataGenerator generator) {
        super(generator);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("livingrock"), StateIngredientHelper.of((ITag.INamedTag<Block>)Tags.Blocks.STONE), ModBlocks.livingrock.func_176223_P()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("livingwood"), StateIngredientHelper.of((ITag.INamedTag<Block>)BlockTags.field_200031_h), ModBlocks.livingwood.func_176223_P()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("cobblestone"), StateIngredientHelper.of((ITag.INamedTag<Block>)Tags.Blocks.NETHERRACK), Blocks.field_150347_e.func_176223_P()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("sand"), StateIngredientHelper.of(Blocks.field_150425_aM), Blocks.field_150354_m.func_176223_P()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("packed_ice"), StateIngredientHelper.of(Blocks.field_150432_aD), Blocks.field_150403_cj.func_176223_P()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("blue_ice"), StateIngredientHelper.of(Blocks.field_150403_cj), Blocks.field_205164_gk.func_176223_P()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("obsidian"), StateIngredientHelper.of(ModBlocks.blazeBlock), Blocks.field_150343_Z.func_176223_P()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("snow_block"), StateIngredientHelper.of(Blocks.field_150355_j), Blocks.field_196604_cC.func_176223_P()));
    }

    public String func_200397_b() {
        return "Botania Pure Daisy recipes";
    }

    private static ResourceLocation id(String path) {
        return ResourceLocationHelper.prefix("pure_daisy/" + path);
    }

    protected static class FinishedRecipe
    implements IFinishedRecipe {
        public static final int DEFAULT_TIME = 150;
        private final ResourceLocation id;
        private final StateIngredient input;
        private final BlockState outputState;
        private final int time;

        public FinishedRecipe(ResourceLocation id, StateIngredient input, BlockState state) {
            this(id, input, state, 150);
        }

        public FinishedRecipe(ResourceLocation id, StateIngredient input, BlockState state, int time) {
            Preconditions.checkArgument((time >= 0 ? 1 : 0) != 0, (Object)"Time must be nonnegative");
            this.id = id;
            this.input = input;
            this.outputState = state;
            this.time = time;
        }

        public void func_218610_a(JsonObject json) {
            json.add("input", (JsonElement)this.input.serialize());
            json.add("output", (JsonElement)StateIngredientHelper.serializeBlockState(this.outputState));
            if (this.time != 150) {
                json.addProperty("time", (Number)this.time);
            }
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return ModRecipeTypes.PURE_DAISY_SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

