/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.network.PacketHandler;
import vazkii.botania.common.network.PacketJump;

public class ItemCloudPendant
extends ItemBauble {
    private static final Set<PlayerEntity> JUMPING_PLAYERS = Collections.newSetFromMap(new WeakHashMap());
    private static int timesJumped;
    private static boolean jumpDown;

    public ItemCloudPendant(Item.Properties props) {
        super(props);
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity player) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (player == Minecraft.func_71410_x().field_71439_g) {
                ClientPlayerEntity playerSp = (ClientPlayerEntity)player;
                if (playerSp.func_233570_aj_()) {
                    timesJumped = 0;
                } else if (playerSp.field_71158_b.field_78901_c) {
                    if (!jumpDown && timesJumped < ((ItemCloudPendant)stack.func_77973_b()).getMaxAllowedJumps()) {
                        playerSp.func_70664_aZ();
                        PacketHandler.sendToServer(new PacketJump());
                        ++timesJumped;
                    }
                    jumpDown = true;
                } else {
                    jumpDown = false;
                }
            }
        });
    }

    public static void setJumping(PlayerEntity entity) {
        JUMPING_PLAYERS.add(entity);
    }

    public static boolean popJumping(PlayerEntity entity) {
        if (entity.field_70170_p.field_72995_K) {
            return timesJumped > 0;
        }
        return JUMPING_PLAYERS.remove(entity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(BipedModel<?> bipedModel, ItemStack stack, LivingEntity player, MatrixStack ms, IRenderTypeBuffer buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean armor = !player.func_184582_a(EquipmentSlotType.CHEST).func_190926_b();
        bipedModel.field_78115_e.func_228307_a_(ms);
        ms.func_227861_a_(-0.3, 0.4, armor ? 0.05 : 0.12);
        ms.func_227862_a_(0.5f, -0.5f, -0.5f);
        IBakedModel model = stack.func_77973_b() == ModItems.superCloudPendant ? MiscellaneousIcons.INSTANCE.nimbusGem : MiscellaneousIcons.INSTANCE.cirrusGem;
        IVertexBuilder buffer = buffers.getBuffer(Atlases.func_228783_h_());
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, null, model, 1.0f, 1.0f, 1.0f, light, OverlayTexture.field_229196_a_);
    }

    public int getMaxAllowedJumps() {
        return 2;
    }
}

