/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.common.item.brew.ItemBrewBase;

public class MergeVialRecipe
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<MergeVialRecipe> SERIALIZER = new SpecialRecipeSerializer(MergeVialRecipe::new);

    public MergeVialRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingInventory inv, @Nonnull World worldIn) {
        int count = 0;
        Brew brew = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (!(stack.func_77973_b() instanceof ItemBrewBase)) {
                return false;
            }
            ItemBrewBase vial = (ItemBrewBase)stack.func_77973_b();
            if (brew == null) {
                brew = vial.getBrew(stack);
            } else if (brew != vial.getBrew(stack)) {
                return false;
            }
            ++count;
        }
        return count > 1;
    }

    @Nonnull
    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack firstStack = ItemStack.field_190927_a;
        ItemBrewBase brew = null;
        int swigs = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (brew == null) {
                firstStack = stack.func_77946_l();
                brew = (ItemBrewBase)stack.func_77973_b();
            }
            if ((swigs += brew.getSwigsLeft(stack)) < brew.getSwigs()) continue;
            swigs = brew.getSwigs();
            break;
        }
        ((ItemBrewBase)Objects.requireNonNull(brew)).setSwigsLeft(firstStack, swigs);
        return firstStack;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList remaining = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        boolean foundFirst = false;
        int swigs = 0;
        int maxSwigs = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            ItemBrewBase brew = (ItemBrewBase)stack.func_77973_b();
            if (!foundFirst) {
                foundFirst = true;
                swigs = brew.getSwigsLeft(stack);
                maxSwigs = brew.getSwigs();
                continue;
            }
            if ((swigs += brew.getSwigsLeft(stack)) > maxSwigs) {
                brew.setSwigsLeft(stack, swigs - maxSwigs);
                swigs = maxSwigs;
                remaining.set(i, (Object)stack.func_77946_l());
                continue;
            }
            remaining.set(i, (Object)brew.getBaseStack());
        }
        return remaining;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height > 2;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

