/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vazkii.botania.api.mana.IManaItem;

public class ManaUpgradeRecipe
implements ICraftingRecipe {
    private final ShapedRecipe compose;
    public static final IRecipeSerializer<ManaUpgradeRecipe> SERIALIZER = new Serializer();

    public ManaUpgradeRecipe(ShapedRecipe compose) {
        this.compose = compose;
    }

    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public static ItemStack output(ItemStack output, IInventory inv) {
        ItemStack out = output.func_77946_l();
        if (!(out.func_77973_b() instanceof IManaItem)) {
            return out;
        }
        IManaItem outItem = (IManaItem)out.func_77973_b();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IManaItem)) continue;
            IManaItem item = (IManaItem)stack.func_77973_b();
            outItem.addMana(out, item.getMana(stack));
        }
        return out;
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        return this.compose.func_77569_a(inv, world);
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        return ManaUpgradeRecipe.output(this.compose.func_77572_b(inv), (IInventory)inv);
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.compose.func_192400_c();
    }

    public boolean func_194133_a(int width, int height) {
        return this.compose.func_194133_a(width, height);
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.compose.func_77571_b();
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.compose.func_199560_c();
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ManaUpgradeRecipe> {
        private Serializer() {
        }

        public ManaUpgradeRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            return new ManaUpgradeRecipe((ShapedRecipe)IRecipeSerializer.field_222157_a.func_199425_a_(recipeId, json));
        }

        public ManaUpgradeRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
            return new ManaUpgradeRecipe((ShapedRecipe)IRecipeSerializer.field_222157_a.func_199426_a_(recipeId, buffer));
        }

        public void write(@Nonnull PacketBuffer buffer, ManaUpgradeRecipe recipe) {
            IRecipeSerializer.field_222157_a.func_199427_a_(buffer, (IRecipe)recipe.compose);
        }
    }
}

