/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class FuzzyNBTIngredient
extends Ingredient {
    public static final IIngredientSerializer<FuzzyNBTIngredient> SERIALIZER = new Serializer();
    private static final String ACCEPTS_EMPTY_TAG = "accepts_empty_tag";
    private final ItemStack stack;
    private final boolean acceptsEmptyTag;

    public FuzzyNBTIngredient(ItemStack stack, boolean acceptsEmptyTag) {
        super(Stream.of(new Ingredient.SingleItemList(stack)));
        this.stack = stack;
        this.acceptsEmptyTag = acceptsEmptyTag;
        if (!stack.func_77942_o()) {
            throw new IllegalArgumentException("This ingredient type requires a stack with NBT!");
        }
    }

    public FuzzyNBTIngredient(ItemStack stack) {
        this(stack, false);
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null || this.stack.func_77973_b() != input.func_77973_b()) {
            return false;
        }
        CompoundNBT tag = input.func_77978_p();
        if (this.acceptsEmptyTag && (tag == null || tag.isEmpty())) {
            return true;
        }
        return ItemNBTHelper.matchTag((INBT)this.stack.func_77978_p(), (INBT)tag);
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID(SERIALIZER).toString());
        json.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.stack.func_77973_b()).toString());
        json.addProperty("count", (Number)this.stack.func_190916_E());
        json.addProperty("nbt", this.stack.func_77978_p().toString());
        json.addProperty(ACCEPTS_EMPTY_TAG, Boolean.valueOf(this.acceptsEmptyTag));
        return json;
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        return new ItemStack[]{this.stack};
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements IIngredientSerializer<FuzzyNBTIngredient> {
        private Serializer() {
        }

        @Nonnull
        public FuzzyNBTIngredient parse(@Nonnull PacketBuffer buffer) {
            return new FuzzyNBTIngredient(buffer.func_150791_c(), buffer.readBoolean());
        }

        @Nonnull
        public FuzzyNBTIngredient parse(@Nonnull JsonObject json) {
            boolean acceptsEmptyTag = JSONUtils.func_151209_a((JsonObject)json, (String)FuzzyNBTIngredient.ACCEPTS_EMPTY_TAG, (boolean)false);
            return new FuzzyNBTIngredient(ShapedRecipe.func_199798_a((JsonObject)json), acceptsEmptyTag);
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull FuzzyNBTIngredient ingredient) {
            buffer.func_150788_a(ingredient.stack);
            buffer.writeBoolean(ingredient.acceptsEmptyTag);
        }
    }
}

