/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.OrechidOutput;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ModSounds;

public class SubTileOrechid
extends TileEntityFunctionalFlower {
    private static final int COST = 17500;
    private static final int COST_GOG = 700;
    private static final int DELAY = 100;
    private static final int DELAY_GOG = 2;
    private static final int RANGE = 5;
    private static final int RANGE_Y = 3;

    public SubTileOrechid(TileEntityType<?> type) {
        super(type);
    }

    public SubTileOrechid() {
        this(ModSubtiles.ORECHID);
    }

    @Override
    public void tickFlower() {
        BlockState state;
        BlockPos coords;
        super.tickFlower();
        if (this.func_145831_w().field_72995_K || this.redstoneSignal > 0 || !this.canOperate()) {
            return;
        }
        int cost = this.getCost();
        if (this.getMana() >= cost && this.ticksExisted % this.getDelay() == 0 && (coords = this.getCoordsToPut()) != null && (state = this.getOreToPut()) != null) {
            this.func_145831_w().func_175656_a(coords, state);
            if (((Boolean)ConfigHandler.COMMON.blockBreakParticles.get()).booleanValue()) {
                this.func_145831_w().func_217379_c(2001, coords, Block.func_196246_j((BlockState)state));
            }
            this.func_145831_w().func_184133_a(null, coords, ModSounds.orechid, SoundCategory.BLOCKS, 2.0f, 1.0f);
            this.addMana(-cost);
            this.sync();
        }
    }

    @Nullable
    private BlockState getOreToPut() {
        List<OrechidOutput> values = this.getOreList();
        if (values.isEmpty()) {
            return null;
        }
        StateIngredient ore = ((OrechidOutput)WeightedRandom.func_76271_a((Random)this.func_145831_w().field_73012_v, values)).getOutput();
        return ore.pick(this.func_145831_w().func_201674_k());
    }

    private BlockPos getCoordsToPut() {
        ArrayList<BlockPos> possibleCoords = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)this.getEffectivePos().func_177982_a(-5, -3, -5), (BlockPos)this.getEffectivePos().func_177982_a(5, 3, 5))) {
            BlockState state = this.func_145831_w().func_180495_p(pos);
            if (!this.getReplaceMatcher().test(state)) continue;
            possibleCoords.add(pos.func_185334_h());
        }
        if (possibleCoords.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleCoords.get(this.func_145831_w().field_73012_v.nextInt(possibleCoords.size()));
    }

    public boolean canOperate() {
        return true;
    }

    public List<OrechidOutput> getOreList() {
        return BotaniaAPI.instance().getOrechidWeights();
    }

    public Predicate<BlockState> getReplaceMatcher() {
        return state -> state.func_177230_c() == Blocks.field_150348_b;
    }

    public int getCost() {
        return Botania.gardenOfGlassLoaded ? 700 : 17500;
    }

    public int getDelay() {
        return Botania.gardenOfGlassLoaded ? 2 : 100;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 5);
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 0x818181;
    }

    @Override
    public int getMaxMana() {
        return this.getCost();
    }
}

