/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.Botania;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class MultiCraftingProcessor
implements IComponentProcessor {
    private List<ICraftingRecipe> recipes;
    private boolean shapeless = true;
    private int longestIngredientSize = 0;
    private boolean hasCustomHeading;

    public void setup(IVariableProvider variables) {
        List names = variables.get("recipes").asStream().map(IVariable::asString).collect(Collectors.toList());
        this.recipes = new ArrayList<ICraftingRecipe>();
        for (String name : names) {
            ICraftingRecipe recipe = (ICraftingRecipe)PatchouliUtils.getRecipe(IRecipeType.field_222149_a, new ResourceLocation(name));
            if (recipe != null) {
                this.recipes.add(recipe);
                if (this.shapeless) {
                    this.shapeless = !(recipe instanceof IShapedRecipe);
                }
                for (Ingredient ingredient : recipe.func_192400_c()) {
                    int size = ingredient.func_193365_a().length;
                    if (this.longestIngredientSize >= size) continue;
                    this.longestIngredientSize = size;
                }
                continue;
            }
            Botania.LOGGER.warn("Missing crafting recipe " + name);
        }
        this.hasCustomHeading = variables.has("heading");
    }

    public IVariable process(String key) {
        if (this.recipes.isEmpty()) {
            return null;
        }
        if (key.equals("heading")) {
            if (!this.hasCustomHeading) {
                return IVariable.from((Object)this.recipes.get(0).func_77571_b().func_200301_q());
            }
            return null;
        }
        if (key.startsWith("input")) {
            int index = Integer.parseInt(key.substring(5)) - 1;
            int shapedX = index % 3;
            int shapedY = index / 3;
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            for (ICraftingRecipe recipe : this.recipes) {
                if (recipe instanceof IShapedRecipe) {
                    IShapedRecipe shaped = (IShapedRecipe)recipe;
                    if (shaped.getRecipeWidth() < shapedX + 1) {
                        ingredients.add(Ingredient.field_193370_a);
                        continue;
                    }
                    int realIndex = index - shapedY * (3 - shaped.getRecipeWidth());
                    NonNullList list = recipe.func_192400_c();
                    ingredients.add(list.size() > realIndex ? (Ingredient)list.get(realIndex) : Ingredient.field_193370_a);
                    continue;
                }
                NonNullList list = recipe.func_192400_c();
                ingredients.add(list.size() > index ? (Ingredient)list.get(index) : Ingredient.field_193370_a);
            }
            return PatchouliUtils.interweaveIngredients(ingredients, this.longestIngredientSize);
        }
        if (key.equals("output")) {
            return IVariable.wrapList((Iterable)this.recipes.stream().map(IRecipe::func_77571_b).map(IVariable::from).collect(Collectors.toList()));
        }
        if (key.equals("shapeless")) {
            return IVariable.wrap((Boolean)this.shapeless);
        }
        return null;
    }
}

