/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavebiomes.core.registries;

import com.blackgear.cavebiomes.common.worldgen.NoiseCaveCarver;
import com.mojang.serialization.Codec;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="cavebiomeapi", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CaveCarvers {
    public static final DeferredRegister<WorldCarver<?>> CARVERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.WORLD_CARVERS, (String)"cavebiomeapi");
    public static final WorldCarver<ProbabilityConfig> NOISE_CARVER = new NoiseCaveCarver((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_);
    public static final ConfiguredCarver<ProbabilityConfig> NOISE_CARVER_CONFIG = CaveCarvers.registerConfiguredCarver("noise_carver", NOISE_CARVER.func_242761_a((ICarverConfig)new ProbabilityConfig(1.0f)));

    @SubscribeEvent
    public static void registerCarvers(RegistryEvent.Register<WorldCarver<?>> event) {
        event.getRegistry().register(NOISE_CARVER.setRegistryName("cavebiomeapi", "noise_carver"));
    }

    public static <C extends ICarverConfig, CC extends ConfiguredCarver<C>> CC registerConfiguredCarver(String key, CC configuredCarver) {
        ResourceLocation location = new ResourceLocation("cavebiomeapi", key);
        if (WorldGenRegistries.field_243652_d.func_148742_b().contains(location)) {
            throw new IllegalStateException("The Configured Carver " + key + "already exists in the registry");
        }
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243652_d, (ResourceLocation)location, configuredCarver);
        return configuredCarver;
    }
}

