/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavebiomes.core.registries;

import java.util.function.Supplier;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class CaveBiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"cavebiomeapi");
    public static final RegistryObject<Biome> CAVE = CaveBiomes.registerBiome("caves", CaveBiomes::createDefaultCaves);

    private static <B extends Biome> RegistryObject<B> registerBiome(String key, Supplier<? extends B> biome) {
        return BIOMES.register(key, biome);
    }

    public static Biome createDefaultCaves() {
        MobSpawnInfo.Builder spawnSettings = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawnSettings);
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generationSettings);
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(0.125f).func_205420_b(0.05f).func_205414_c(0.8f).func_205417_d(0.4f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(CaveBiomes.calculateSkyColor()).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(spawnSettings.func_242577_b()).func_242457_a(generationSettings.func_242508_a()).func_242455_a();
    }

    private static int calculateSkyColor() {
        float modifier = 0.26666668f;
        modifier = MathHelper.func_76131_a((float)modifier, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - modifier * 0.05f), (float)(0.5f + modifier * 0.1f), (float)1.0f);
    }
}

