/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.autumnity.core.other;

import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.minecraftabnormals.autumnity.core.AutumnityConfig;
import com.minecraftabnormals.autumnity.core.registry.AutumnityBiomes;
import com.minecraftabnormals.autumnity.core.registry.AutumnityEntities;
import com.minecraftabnormals.autumnity.core.registry.AutumnityFeatures;
import com.minecraftabnormals.autumnity.core.registry.AutumnityStructures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="autumnity")
public class AutumnityGeneration {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEarlyBiomeLoad(BiomeLoadingEvent event) {
        ResourceLocation biome = event.getName();
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        MobSpawnInfoBuilder spawns = event.getSpawns();
        if (biome == null) {
            return;
        }
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AutumnityBiomes.MAPLE_FOREST.getKey(), AutumnityBiomes.MAPLE_FOREST_HILLS.getKey(), AutumnityBiomes.PUMPKIN_FIELDS.getKey()})) {
            DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)generation);
            generation.func_242516_a(StructureFeatures.field_244159_y);
            generation.func_242516_a(AutumnityStructures.Configured.MAPLE_WITCH_HUT);
            DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawns);
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)AutumnityEntities.SNAIL.get(), 16, 2, 2));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)AutumnityEntities.TURKEY.get(), 10, 4, 4));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200737_ac, 12, 4, 4));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200784_X, 10, 4, 4));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200796_j, 8, 4, 4));
            if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AutumnityBiomes.MAPLE_FOREST.getKey(), AutumnityBiomes.MAPLE_FOREST_HILLS.getKey()})) {
                DefaultBiomeFeatures.func_243707_U((BiomeGenerationSettings.Builder)generation);
                DefaultBiomeFeatures.func_243701_O((BiomeGenerationSettings.Builder)generation);
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AutumnityFeatures.Configured.MAPLE_FOREST_VEGETATION);
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AutumnityFeatures.Configured.FLOWER_MAPLE_FOREST);
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AutumnityFeatures.Configured.PATCH_GRASS_MAPLE_FOREST);
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AutumnityFeatures.Configured.FALLEN_LEAVES);
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AutumnityFeatures.Configured.PATCH_FOUL_BERRY_BUSH);
                spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)AutumnityEntities.TURKEY.get(), 10, 4, 4));
            }
            if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AutumnityBiomes.PUMPKIN_FIELDS.getKey()})) {
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243848_au);
                DefaultBiomeFeatures.func_243711_Y((BiomeGenerationSettings.Builder)generation);
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AutumnityFeatures.Configured.PUMPKIN_FIELDS_VEGETATION);
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AutumnityFeatures.Configured.FLOWER_PUMPKIN_FIELDS);
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AutumnityFeatures.Configured.PATCH_GRASS_PUMPKIN_FIELDS);
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AutumnityFeatures.Configured.PATCH_PUMPKINS_PUMPKIN_FIELDS);
            }
        } else if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AutumnityBiomes.YELLOW_SPOTTED_FOREST.getKey()})) {
            DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243700_N((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243707_U((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243701_O((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)generation);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AutumnityFeatures.Configured.MAPLE_TREE_YELLOW_SPOTTED_FOREST);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AutumnityFeatures.Configured.YELLOW_SPOTTED_FOREST_VEGETATION);
            generation.func_242516_a(StructureFeatures.field_244159_y);
            DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawns);
            DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)spawns);
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200724_aC, 5, 4, 4));
        } else if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AutumnityBiomes.ORANGE_SPOTTED_DARK_FOREST.getKey()})) {
            DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243700_N((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243707_U((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243701_O((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)generation);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AutumnityFeatures.Configured.ORANGE_SPOTTED_DARK_FOREST_VEGETATION);
            generation.func_242516_a(StructureFeatures.field_244159_y);
            generation.func_242516_a(StructureFeatures.field_244138_d);
            DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawns);
            DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)spawns);
        } else if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AutumnityBiomes.RED_SPOTTED_TAIGA.getKey()})) {
            DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243757_q((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243707_U((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243710_X((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243759_s((BiomeGenerationSettings.Builder)generation);
            DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)generation);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AutumnityFeatures.Configured.RED_SPOTTED_TAIGA_VEGETATION);
            generation.func_242516_a(StructureFeatures.field_244159_y);
            generation.func_242516_a(StructureFeatures.field_244158_x);
            generation.func_242516_a(StructureFeatures.field_244135_a);
            DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawns);
            DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)spawns);
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200724_aC, 8, 4, 4));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200736_ab, 4, 2, 3));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_220356_B, 8, 2, 4));
        }
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        ResourceLocation biome = event.getName();
        MobSpawnInfoBuilder spawns = event.getSpawns();
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        if (biome == null) {
            return;
        }
        if (!DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AutumnityBiomes.MAPLE_FOREST.getKey(), AutumnityBiomes.MAPLE_FOREST_HILLS.getKey(), AutumnityBiomes.PUMPKIN_FIELDS.getKey()})) {
            if (((List)AutumnityConfig.COMMON.snailSpawnBiomes.get()).contains(biome.toString())) {
                spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)AutumnityEntities.SNAIL.get(), 10, 2, 2));
            }
            if (((List)AutumnityConfig.COMMON.turkeySpawnBiomes.get()).contains(biome.toString())) {
                spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)AutumnityEntities.TURKEY.get(), 10, 4, 4));
            }
            if (((List)AutumnityConfig.COMMON.mapleTreeBiomes.get()).contains(biome.toString())) {
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AutumnityFeatures.Configured.MAPLE_TREE);
            }
        }
        AutumnityGeneration.removeSpawns(event);
    }

    private static void removeSpawns(BiomeLoadingEvent event) {
        MobSpawnInfoBuilder spawns = event.getSpawns();
        ArrayList<MobSpawnInfo.Spawners> entrysToRemove = new ArrayList<MobSpawnInfo.Spawners>();
        for (MobSpawnInfo.Spawners entry : spawns.getSpawner(EntityClassification.CREATURE)) {
            if (!((List)AutumnityConfig.COMMON.turkeySpawnBiomes.get()).contains(event.getName().toString()) || entry.field_242588_c != EntityType.field_200795_i) continue;
            entrysToRemove.add(entry);
        }
        spawns.getSpawner(EntityClassification.CREATURE).removeAll(entrysToRemove);
    }
}

