/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.autumnity.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import com.minecraftabnormals.autumnity.common.entity.passive.SnailEntity;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SnailModel<T extends SnailEntity>
extends AgeableModel<T> {
    private final ModelRenderer body;
    private final ModelRenderer hideBody;
    private final ModelRenderer shell;
    private final ModelRenderer eye1;
    private final ModelRenderer eye2;
    private final ModelRenderer tentacle1;
    private final ModelRenderer tentacle2;

    public SnailModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, 24.0f, -9.0f);
        this.body.func_228301_a_(-4.0f, 0.0f, 0.0f, 8.0f, 18.0f, 6.0f, 0.0f);
        this.hideBody = new ModelRenderer((Model)this);
        this.hideBody.func_78793_a(0.0f, 24.0f, -6.0f);
        this.hideBody.func_228301_a_(-4.0f, 0.0f, 0.0f, 8.0f, 12.0f, 6.0f, 0.0f);
        this.eye1 = new ModelRenderer((Model)this, 28, 0);
        this.eye1.func_78793_a(2.5f, 18.0f, -7.0f);
        this.eye1.func_228301_a_(-1.0f, -6.0f, -1.0f, 2.0f, 7.0f, 2.0f, 0.0f);
        this.eye2 = new ModelRenderer((Model)this, 28, 0);
        this.eye2.field_78809_i = true;
        this.eye2.func_78793_a(-2.5f, 18.0f, -7.0f);
        this.eye2.func_228301_a_(-1.0f, -6.0f, -1.0f, 2.0f, 7.0f, 2.0f, 0.0f);
        this.tentacle1 = new ModelRenderer((Model)this, 28, 9);
        this.tentacle1.func_78793_a(3.0f, 22.0f, -9.0f);
        this.tentacle1.func_228301_a_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 2.0f, 0.0f);
        this.tentacle2 = new ModelRenderer((Model)this, 28, 9);
        this.tentacle2.func_78793_a(-3.0f, 22.0f, -9.0f);
        this.tentacle2.func_228301_a_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 2.0f, 0.0f);
        this.shell = new ModelRenderer((Model)this, 0, 24);
        this.shell.func_78793_a(0.0f, 7.0f, -1.0f);
        this.shell.func_228301_a_(-4.5f, 0.0f, 0.0f, 9.0f, 14.0f, 14.0f, 0.0f);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        float f = ((SnailEntity)((Object)entity)).getHidingAnim(partialTick);
        float f1 = 3.0f * f;
        float f2 = MathHelper.func_76131_a((float)(10.0f * f), (float)0.0f, (float)5.0f);
        this.hideBody.func_78793_a(0.0f, 24.0f, -9.0f + f1);
        this.eye1.func_78793_a(2.5f, 18.0f + f2, -7.0f + f1);
        this.eye2.func_78793_a(-2.5f, 18.0f + f2, -7.0f + f1);
        this.tentacle1.func_78793_a(3.0f, 22.0f, -9.0f + f1);
        this.tentacle2.func_78793_a(-3.0f, 22.0f, -9.0f + f1);
        this.shell.func_78793_a(0.0f, 7.0f, -1.0f - f1);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialtick = ageInTicks - (float)((SnailEntity)((Object)entity)).field_70173_aa;
        float f = ((SnailEntity)((Object)entity)).getHidingAnim(partialtick);
        float f1 = 3.0f * f;
        float f2 = MathHelper.func_76131_a((float)(10.0f * f), (float)0.0f, (float)5.0f);
        float f3 = 1.0f - f;
        this.hideBody.func_78793_a(0.0f, 24.0f, -9.0f + f1);
        this.eye1.func_78793_a(2.5f, 18.0f + f2, -7.0f + f1);
        this.eye2.func_78793_a(-2.5f, 18.0f + f2, -7.0f + f1);
        this.tentacle1.func_78793_a(3.0f, 22.0f, -9.0f + f1);
        this.tentacle2.func_78793_a(-3.0f, 22.0f, -9.0f + f1);
        this.shell.func_78793_a(0.0f, 7.0f, -1.0f - f1);
        this.body.field_78795_f = 1.5707964f;
        this.hideBody.field_78795_f = 1.5707964f;
        this.eye1.field_78795_f = f3 * (headPitch * ((float)Math.PI / 180) * 0.5f + 0.25f);
        this.eye1.field_78796_g = f3 * (netHeadYaw * ((float)Math.PI / 180) * 0.5f);
        this.eye1.field_78808_h = f3 * 0.25f;
        this.eye2.field_78795_f = this.eye1.field_78795_f;
        this.eye2.field_78796_g = this.eye1.field_78796_g;
        this.eye2.field_78808_h = -this.eye1.field_78808_h;
        this.shell.field_78795_f = -0.22f;
        if (((SnailEntity)((Object)entity)).getAction() == SnailEntity.Action.EATING) {
            this.tentacle1.field_78796_g = 0.25f * MathHelper.func_76126_a((float)(0.6f * ageInTicks));
            this.tentacle2.field_78796_g = -this.tentacle1.field_78796_g;
        } else {
            this.tentacle1.field_78796_g = 0.0f;
            this.tentacle2.field_78796_g = 0.0f;
        }
        if (((SnailEntity)((Object)entity)).getHidingAnimTicks() == 0.0f) {
            this.body.field_78806_j = true;
            this.hideBody.field_78806_j = false;
        } else {
            this.body.field_78806_j = false;
            this.hideBody.field_78806_j = true;
        }
        if (((SnailEntity)((Object)entity)).getHidingAnimTicks() < 3.0f) {
            this.eye1.field_78806_j = true;
            this.eye2.field_78806_j = true;
        } else {
            this.eye1.field_78806_j = false;
            this.eye2.field_78806_j = false;
        }
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body, (Object)this.hideBody, (Object)this.eye1, (Object)this.eye2, (Object)this.tentacle1, (Object)this.tentacle2, (Object)this.shell);
    }
}

