/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.data.gen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import javax.annotation.Nullable;
import knightminer.simplytea.core.Registration;
import knightminer.simplytea.item.TeaCupItem;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ShapelessHoneyRecipe
extends ShapelessRecipe {
    private final Item tea;
    private final Ingredient honey;
    private final String tag;

    public ShapelessHoneyRecipe(ResourceLocation id, String group, IItemProvider tea, Ingredient honey, String tag) {
        super(id, group, TeaCupItem.withHoney(new ItemStack(tea), tag), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{tea}), honey}));
        this.tea = tea.func_199767_j();
        this.honey = honey;
        this.tag = tag;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Registration.shapeless_honey;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        if (!super.func_77569_a(inv, worldIn)) {
            return false;
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != this.tea) continue;
            return !TeaCupItem.hasHoney(stack, this.tag);
        }
        return false;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != this.tea) continue;
            return TeaCupItem.withHoney(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1), this.tag);
        }
        return this.func_77571_b().func_77946_l();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (!item.hasContainerItem() || item.func_77973_b() == this.tea) continue;
            list.set(i, (Object)item.getContainerItem());
        }
        return list;
    }

    public static class FinishedRecipe
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Item tea;
        private final Ingredient honey;
        private final String tag;
        private final ResourceLocation advancementId;
        private final Advancement.Builder advancementBuilder;

        public FinishedRecipe(ResourceLocation id, String group, IItemProvider tea, Ingredient honey, String tag, @Nullable ResourceLocation advancementId, @Nullable Advancement.Builder advancementBuilder) {
            this.id = id;
            this.group = group;
            this.tea = tea.func_199767_j();
            this.honey = honey;
            this.tag = tag;
            this.advancementId = advancementId;
            this.advancementBuilder = advancementBuilder;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return Registration.shapeless_honey;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.addProperty("tea", Objects.requireNonNull(this.tea.getRegistryName()).toString());
            json.add("honey", this.honey.func_200304_c());
            json.addProperty("tag", this.tag);
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }

        @Nullable
        public JsonObject func_200440_c() {
            if (this.advancementBuilder == null) {
                return null;
            }
            return this.advancementBuilder.func_200273_b();
        }
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapelessHoneyRecipe> {
        public ShapelessHoneyRecipe read(ResourceLocation id, JsonObject json) {
            String group = JSONUtils.func_151200_h((JsonObject)json, (String)"group");
            String name = JSONUtils.func_151200_h((JsonObject)json, (String)"tea");
            ResourceLocation location = ResourceLocation.func_208304_a((String)name);
            if (location == null) {
                throw new JsonSyntaxException("Invalid tea_cup location '" + name + "'");
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
            if (item == null || item == Items.field_190931_a) {
                throw new JsonSyntaxException("Missing tea_cup item '" + name + "'");
            }
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)json.get("honey"));
            String tag = JSONUtils.func_151219_a((JsonObject)json, (String)"tag", (String)"with_honey");
            return new ShapelessHoneyRecipe(id, group, (IItemProvider)item, ingredient, tag);
        }

        @Nullable
        public ShapelessHoneyRecipe read(ResourceLocation id, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            Item item = (Item)buffer.readRegistryIdUnsafe(ForgeRegistries.ITEMS);
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            String tag = buffer.func_150789_c(Short.MAX_VALUE);
            return new ShapelessHoneyRecipe(id, group, (IItemProvider)item, ingredient, tag);
        }

        public void write(PacketBuffer buffer, ShapelessHoneyRecipe recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (IForgeRegistryEntry)recipe.tea);
            recipe.honey.func_199564_a(buffer);
            buffer.func_180714_a(recipe.tag);
        }
    }
}

