/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.core.config;

import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import knightminer.simplytea.core.Registration;
import knightminer.simplytea.core.config.Drink;
import knightminer.simplytea.data.SimplyTags;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.ForgeConfigSpec;

public class TeaDrink
extends Drink {
    private final TeaEffect type;
    private final ForgeConfigSpec.IntValue configurable;
    private final int constant;

    public TeaDrink(String name, ForgeConfigSpec.Builder builder, TeaEffect type, int hunger, double saturation, int time, int level) {
        super(name, builder, hunger, saturation);
        this.type = type;
        if (type.isLevel()) {
            this.configurable = builder.comment(new String[]{String.format("Level of the %s effect when drinking this tea.", new Object[]{type}), type.getDescription(), "Set to 0 to disable the effect."}).translation("simplytea.config.tea.level").defineInRange("level", level, 0, 10);
            this.constant = time;
        } else {
            this.configurable = builder.comment(new String[]{String.format("Time in seconds for the %s effect from drinking this tea.", new Object[]{type}), type.getDescription(), "Set to 0 to disable the effect."}).translation("simplytea.config.tea.time").defineInRange("time", time, 0, 600);
            this.constant = level;
        }
        builder.pop();
    }

    @Nullable
    public EffectInstance getEffect(boolean hasHoney) {
        int levelOffset = hasHoney ? 0 : -1;
        int configurable = (Integer)this.configurable.get();
        if (configurable != 0) {
            EffectInstance effect = this.type.isLevel() ? new EffectInstance(this.type.getEffect(), this.constant * 20, configurable + levelOffset) : new EffectInstance(this.type.getEffect(), configurable * 20, this.constant + levelOffset);
            List curativeEffects = effect.getCurativeItems();
            curativeEffects.clear();
            for (Item tea : SimplyTags.Items.EXCLUSIVE_TEAS.func_230236_b_()) {
                curativeEffects.add(new ItemStack((IItemProvider)tea));
            }
            return effect;
        }
        return null;
    }

    public List<Pair<EffectInstance, Float>> func_221464_f() {
        return Collections.emptyList();
    }

    public static enum TeaEffect {
        RESTFUL(true, () -> Registration.restful, "Heals one heart after sleeping per level"),
        RELAXED(true, () -> Registration.relaxed, "Heals 0.5 hearts every (60 / level) seconds"),
        CAFFEINATED(false, () -> Registration.caffeinated, "Grants +6% movement and +5% attack speed"),
        INVIGORATED(false, () -> Registration.invigorated, "Grants +1 attack damage and 0.5 knockback"),
        ENDERFALLING(false, () -> Registration.enderfalling, "Grants immunity to ender pearl damage and reduces fall damage"),
        ABSORPTION(true, () -> Effects.field_76444_x, "Grants 2 temporary absorption hearts per level for a short time");

        private final Supplier<Effect> effectSupplier;
        private final boolean level;
        private final String description;

        private TeaEffect(boolean level, Supplier<Effect> effectSupplier, String description) {
            this.effectSupplier = effectSupplier;
            this.level = level;
            this.description = description;
        }

        public boolean isLevel() {
            return this.level;
        }

        public String getDescription() {
            return this.description;
        }

        public Effect getEffect() {
            return this.effectSupplier.get();
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

