/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.core;

import knightminer.simplytea.core.Registration;
import knightminer.simplytea.potion.RestfulEffect;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="simplytea", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Events {
    @SubscribeEvent
    static void playerWakeUp(PlayerWakeUpEvent event) {
        if (event.updateWorld()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (RestfulEffect.removeConflicts((LivingEntity)player)) {
            player.func_195063_d(Registration.restful);
        } else {
            EffectInstance effect = player.func_70660_b(Registration.restful);
            if (effect != null) {
                player.func_70691_i((float)((effect.func_76458_c() + 1) * 2));
                player.func_195063_d(Registration.restful);
            }
        }
    }

    @SubscribeEvent
    static void entityFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntityLiving();
        EffectInstance effect = entity.func_70660_b(Registration.enderfalling);
        if (effect != null) {
            event.setDamageMultiplier(event.getDamageMultiplier() * (float)Math.pow(2.0, -effect.func_76458_c() - 3));
        }
    }

    @SubscribeEvent
    static void throwEnderPearl(EntityTeleportEvent.EnderPearl event) {
        if (event.getPlayer().func_70644_a(Registration.enderfalling)) {
            event.setAttackDamage(0.0f);
        }
    }

    private static boolean validBiome(BiomeLoadingEvent event) {
        if (event.getName() == null) {
            return event.getCategory() == Biome.Category.FOREST;
        }
        return BiomeDictionary.hasType((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName()), (BiomeDictionary.Type)BiomeDictionary.Type.FOREST);
    }

    @SubscribeEvent
    static void onBiomeLoad(BiomeLoadingEvent event) {
        if (Events.validBiome(event)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Registration.configured_tea_tree);
        }
    }
}

