/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.fins.common.items;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import teamdraco.fins.FinsAndTails;
import teamdraco.fins.client.model.GopjetJetpackModel;
import teamdraco.fins.common.items.FinsArmorMaterial;
import teamdraco.fins.init.FinsItems;
import teamdraco.fins.init.FinsSounds;

public class GopjetJetpackItem
extends ArmorItem {
    public static final IArmorMaterial MATERIAL = new FinsArmorMaterial("fins:gopjet_jetpack", 0, new int[]{0, 0, 0, 0}, 1, SoundEvents.field_187728_s, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)FinsItems.GOPJET_JET.get()}));
    private int bubbleSoundTime;

    public GopjetJetpackItem() {
        super(MATERIAL, EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(FinsAndTails.GROUP).func_200917_a(1).func_200918_c(128));
    }

    public BlockPos getBlockUnderPlayer(PlayerEntity player) {
        BlockState state;
        BlockPos.Mutable position = player.func_233580_cy_().func_239590_i_();
        while (!(state = player.field_70170_p.func_180495_p((BlockPos)position)).func_185904_a().func_76230_c() && state.func_204520_s().func_206888_e() || state.func_177230_c() instanceof LeavesBlock) {
            position.func_189536_c(Direction.DOWN);
            if (position.func_177956_o() > 0) continue;
            return null;
        }
        return position;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (stack.func_77958_k() - stack.func_77952_i() > 1 || player.field_71075_bZ.field_75098_d) {
            CompoundNBT persistentData;
            Item item;
            boolean canFly = world.func_175727_C(player.func_233580_cy_());
            int flyingTicksRemaining = 0;
            int stackIndex = -1;
            BlockPos pos = this.getBlockUnderPlayer(player);
            if (!canFly && pos != null) {
                if (canFly || player.func_233580_cy_().func_177956_o() > 0 && world.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
                    canFly = true;
                } else {
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        int ticksJumping;
                        ItemStack inventoryStack = player.field_71071_by.func_70301_a(i);
                        item = inventoryStack.func_77973_b();
                        int n = ticksJumping = inventoryStack.func_77942_o() ? inventoryStack.func_77978_p().func_74762_e("FinsFlyingTicks") : 0;
                        if (item == Items.field_151131_as) {
                            flyingTicksRemaining = 100 - ticksJumping;
                        } else {
                            if (item != Items.field_151068_bn || PotionUtils.func_185191_c((ItemStack)inventoryStack) != Potions.field_185230_b) continue;
                            flyingTicksRemaining = 30 - ticksJumping;
                        }
                        stackIndex = i;
                        canFly = true;
                        break;
                    }
                }
            }
            if ((persistentData = player.getPersistentData()).func_74767_n("FinsFlying") && pos != null) {
                if (canFly || player.func_233580_cy_().func_177956_o() > 0 && world.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
                    player.field_70143_R = 0.0f;
                    int ticksJumping = persistentData.func_74762_e("FinsFlyingTicks") + 1;
                    if (ticksJumping % 10 == 0) {
                        stack.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213361_c(EquipmentSlotType.CHEST));
                    }
                    persistentData.func_74768_a("FinsFlyingTicks", ticksJumping);
                    player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, 0.1, 0.0));
                }
                if (canFly || player.func_233580_cy_().func_177956_o() > 0 && world.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
                    if (field_77697_d.nextInt(100) < this.bubbleSoundTime++) {
                        this.bubbleSoundTime = 0;
                        world.func_184133_a(player, player.func_233580_cy_(), (SoundEvent)FinsSounds.JETPACK_USE.get(), SoundCategory.AMBIENT, 1.0f, 1.0f);
                    }
                    if (world.field_72995_K) {
                        for (int i = 0; i < 4; ++i) {
                            float sign = Math.signum(i - 2);
                            if (sign == 0.0f) {
                                sign = 1.0f;
                            }
                            double playerRotation = Math.toRadians(player.field_70761_aq + 35.0f * sign);
                            double xOffset = field_77697_d.nextGaussian() * 0.05;
                            double yOffset = field_77697_d.nextGaussian() * 0.01;
                            double zOffset = field_77697_d.nextGaussian() * 0.05;
                            double xPos = player.func_226277_ct_() + xOffset - Math.sin(-playerRotation) * 0.35;
                            double yPos = player.func_226278_cu_() + yOffset + 0.7;
                            double zPos = player.func_226281_cx_() + zOffset - Math.cos(playerRotation) * 0.35;
                            for (int j = 0; j <= 8; ++j) {
                                world.func_195594_a((IParticleData)(field_77697_d.nextInt(2) == 0 ? ParticleTypes.field_218422_X : ParticleTypes.field_197612_e), xPos, yPos, zPos, 0.0, -0.1, 0.0);
                            }
                        }
                    }
                    if (stackIndex != -1) {
                        ItemStack flyingStack = player.field_71071_by.func_70301_a(stackIndex);
                        if (flyingTicksRemaining - 1 <= 0) {
                            item = flyingStack.func_77973_b();
                            flyingStack.func_190918_g(1);
                            ItemStack newStack = null;
                            if (item == Items.field_151131_as) {
                                newStack = new ItemStack((IItemProvider)Items.field_151133_ar);
                            } else if (item == Items.field_151068_bn && PotionUtils.func_185191_c((ItemStack)flyingStack) == Potions.field_185230_b) {
                                newStack = new ItemStack((IItemProvider)Items.field_151069_bo);
                            } else if (Block.func_149634_a((Item)item) == Blocks.field_196577_ad) {
                                newStack = new ItemStack((IItemProvider)Blocks.field_150360_v);
                            }
                            if (newStack != null) {
                                if (flyingStack.func_190926_b()) {
                                    player.field_71071_by.func_70299_a(stackIndex, newStack);
                                } else if (!player.field_71071_by.func_70441_a(newStack)) {
                                    player.func_71019_a(newStack, false);
                                }
                                flyingStack.func_196082_o().func_82580_o("FinsFlyingTicks");
                            }
                        } else {
                            CompoundNBT tag = flyingStack.func_196082_o();
                            tag.func_74768_a("FinsFlyingTicks", tag.func_74762_e("FinsFlyingTicks") + 1);
                        }
                    }
                }
            }
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment != Enchantments.field_185307_s && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        return (A)((Object)GopjetJetpackModel.INSTANCE);
    }
}

