/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.fins.common.items;

import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import teamdraco.fins.common.entities.WherbleEntity;
import teamdraco.fins.common.items.FinsBucketItem;

public class BabyWherblePotItem
extends FinsBucketItem {
    private final Supplier<? extends EntityType<?>> entityTypeSupplier;
    private final Supplier<? extends Fluid> fluid;

    public BabyWherblePotItem(Supplier<? extends EntityType<?>> entityType, Supplier<? extends Fluid> fluid, Item.Properties builder) {
        super(entityType, fluid, builder);
        this.entityTypeSupplier = entityType;
        this.fluid = fluid;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        BlockRayTraceResult raytraceresult;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        ActionResult ret = ForgeEventFactory.onBucketUse((PlayerEntity)playerIn, (World)worldIn, (ItemStack)itemstack, (RayTraceResult)(raytraceresult = BabyWherblePotItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE)));
        if (ret != null) {
            return ret;
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        BlockPos blockpos = raytraceresult.func_216350_a();
        Direction direction = raytraceresult.func_216354_b();
        BlockPos blockpos1 = blockpos.func_177972_a(direction);
        if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos1, direction, itemstack)) {
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            BlockPos blockpos2 = blockstate.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)blockstate.func_177230_c()).func_204510_a((IBlockReader)worldIn, blockpos, blockstate, this.fluid.get()) ? blockpos : blockpos1;
            this.func_180616_a(playerIn, worldIn, blockpos2, raytraceresult);
            if (worldIn instanceof ServerWorld) {
                this.placeEntity((ServerWorld)worldIn, itemstack, blockpos2);
            }
            if (playerIn instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerIn, blockpos2, itemstack);
            }
            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_233538_a_((Object)this.func_203790_a(itemstack, playerIn), (boolean)worldIn.func_201670_d());
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    private void placeEntity(ServerWorld worldIn, ItemStack stack, BlockPos pos) {
        Entity entity = this.entityTypeSupplier.get().func_220331_a(worldIn, stack, (PlayerEntity)null, pos, SpawnReason.BUCKET, true, false);
        if (entity != null && entity instanceof WherbleEntity) {
            ((WherbleEntity)entity).func_70873_a(-24000);
            ((WherbleEntity)entity).setVariant(field_77697_d.nextInt(4));
        }
    }

    @Override
    protected EntityType<?> getEntityType() {
        return this.entityTypeSupplier.get();
    }

    @Override
    protected ItemStack func_203790_a(ItemStack stack, PlayerEntity player) {
        return !player.field_71075_bZ.field_75098_d ? new ItemStack((IItemProvider)Items.field_151133_ar) : stack;
    }
}

