/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.fins.common.entities.util.goals;

import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.JumpGoal;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import teamdraco.fins.common.entities.SwampMuckerEntity;

public class SwampMuckerJumpGoal
extends JumpGoal {
    private static final int[] JUMP_DISTANCES = new int[]{0, 1, 4, 5, 6, 7};
    private final SwampMuckerEntity swampMucker;
    private final int interval;
    private boolean breached;

    public SwampMuckerJumpGoal(SwampMuckerEntity p_i50329_1_, int p_i50329_2_) {
        this.swampMucker = p_i50329_1_;
        this.interval = p_i50329_2_;
    }

    public boolean func_75250_a() {
        if (this.swampMucker.func_70681_au().nextInt(this.interval) != 0) {
            return false;
        }
        Direction direction = this.swampMucker.func_184172_bi();
        int i = direction.func_82601_c();
        int j = direction.func_82599_e();
        BlockPos blockpos = this.swampMucker.func_233580_cy_();
        for (int k : JUMP_DISTANCES) {
            if (this.canJumpTo(blockpos, i, j, k) && this.isAirAbove(blockpos, i, j, k)) continue;
            return false;
        }
        return true;
    }

    private boolean canJumpTo(BlockPos pos, int dx, int dz, int scale) {
        BlockPos blockpos = pos.func_177982_a(dx * scale, 0, dz * scale);
        return this.swampMucker.field_70170_p.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a) && !this.swampMucker.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76230_c();
    }

    private boolean isAirAbove(BlockPos pos, int dx, int dz, int scale) {
        return this.swampMucker.field_70170_p.func_180495_p(pos.func_177982_a(dx * scale, 1, dz * scale)).func_196958_f() && this.swampMucker.field_70170_p.func_180495_p(pos.func_177982_a(dx * scale, 2, dz * scale)).func_196958_f();
    }

    public boolean func_75253_b() {
        double d0 = this.swampMucker.func_213322_ci().field_72448_b;
        return !(d0 * d0 < (double)0.03f && this.swampMucker.field_70125_A != 0.0f && Math.abs(this.swampMucker.field_70125_A) < 10.0f && this.swampMucker.func_70090_H() || this.swampMucker.func_233570_aj_());
    }

    public boolean func_220685_C_() {
        return false;
    }

    public void func_75249_e() {
        Direction direction = this.swampMucker.func_184172_bi();
        this.swampMucker.func_213317_d(this.swampMucker.func_213322_ci().func_72441_c((double)direction.func_82601_c() * 0.6, 0.7, (double)direction.func_82599_e() * 0.6));
        this.swampMucker.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.swampMucker.field_70125_A = 0.0f;
    }

    public void func_75246_d() {
        boolean flag = this.breached;
        if (!flag) {
            FluidState ifluidstate = this.swampMucker.field_70170_p.func_204610_c(new BlockPos((Vector3i)this.swampMucker.func_233580_cy_()));
            this.breached = ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a);
        }
        if (this.breached && !flag) {
            this.swampMucker.func_184185_a(SoundEvents.field_205209_aZ, 1.0f, 1.0f);
        }
        Vector3d vector3d = this.swampMucker.func_213322_ci();
        if (vector3d.field_72448_b * vector3d.field_72448_b < (double)0.03f && this.swampMucker.field_70125_A != 0.0f) {
            this.swampMucker.field_70125_A = MathHelper.func_226167_j_((float)this.swampMucker.field_70125_A, (float)0.0f, (float)0.2f);
        } else {
            double d0 = Math.sqrt(Entity.func_213296_b((Vector3d)vector3d));
            double d1 = Math.signum(-vector3d.field_72448_b) * Math.acos(d0 / vector3d.func_72433_c()) * 57.2957763671875;
            this.swampMucker.field_70125_A = (float)d1;
        }
    }
}

